/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class MethodPropertyHandle
implements PropertyHandle {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final Method method;

    public MethodPropertyHandle(String name, Method method) {
        this.name = name;
        this.method = method;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.method + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(Object thiz) {
        try {
            return this.method.invoke(thiz, new Object[0]);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw log.errorInvokingMember(this.method, thiz, e);
        }
    }

    @Override
    public int hashCode() {
        return this.method.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        MethodPropertyHandle other = (MethodPropertyHandle)obj;
        return this.name.equals(other.name) && this.method.equals(other.method);
    }
}

