/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundRoutingKeyBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundTypeBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PropertyHandle;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoProcessorNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorPropertyNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorTypeNode;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class PojoIndexingProcessorTypeNodeBuilder<T>
extends AbstractPojoProcessorNodeBuilder
implements PojoMappingCollectorTypeNode {
    private final BoundPojoModelPathTypeNode<T> modelPath;
    private final Optional<PojoIdentityMappingCollector> identityMappingCollector;
    private final Collection<IndexObjectFieldReference> parentIndexObjectReferences;
    private BoundRoutingKeyBridge<T> boundRoutingKeyBridge;
    private final Collection<BoundTypeBridge<T>> boundBridges = new ArrayList<BoundTypeBridge<T>>();
    private final Map<PropertyHandle, PojoIndexingProcessorPropertyNodeBuilder<T, ?>> propertyNodeBuilders = new LinkedHashMap();

    public PojoIndexingProcessorTypeNodeBuilder(BoundPojoModelPathTypeNode<T> modelPath, PojoMappingHelper mappingHelper, IndexBindingContext bindingContext, Optional<PojoIdentityMappingCollector> identityMappingCollector, Collection<IndexObjectFieldReference> parentIndexObjectReferences) {
        super(mappingHelper, bindingContext);
        this.modelPath = modelPath;
        this.identityMappingCollector = identityMappingCollector;
        this.parentIndexObjectReferences = parentIndexObjectReferences;
    }

    @Override
    public void bridge(BridgeBuilder<? extends TypeBridge> builder) {
        this.mappingHelper.getIndexModelBinder().addTypeBridge(this.bindingContext, this.modelPath, builder).ifPresent(this.boundBridges::add);
    }

    @Override
    public void routingKeyBridge(BridgeBuilder<? extends RoutingKeyBridge> builder) {
        if (this.identityMappingCollector.isPresent()) {
            this.boundRoutingKeyBridge = this.identityMappingCollector.get().routingKeyBridge(this.modelPath, builder);
        }
    }

    @Override
    public PojoMappingCollectorPropertyNode property(String propertyName) {
        PojoPropertyModel<?> propertyModel = ((BoundPojoModelPathTypeNode)this.getModelPath()).getTypeModel().getProperty(propertyName);
        PropertyHandle propertyHandle = propertyModel.getHandle();
        return this.propertyNodeBuilders.computeIfAbsent(propertyHandle, this::createPropertyNodeBuilder);
    }

    private PojoIndexingProcessorPropertyNodeBuilder<T, ?> createPropertyNodeBuilder(PropertyHandle propertyHandle) {
        return new PojoIndexingProcessorPropertyNodeBuilder(this.modelPath.property(propertyHandle), this.mappingHelper, this.bindingContext, this.identityMappingCollector);
    }

    @Override
    BoundPojoModelPathTypeNode<T> getModelPath() {
        return this.modelPath;
    }

    @Override
    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(boundBridge -> ((TypeBridge)boundBridge.getBridgeHolder().get()).close(), this.boundBridges);
            closer.pushAll(boundBridge -> boundBridge.getBridgeHolder().close(), this.boundBridges);
            closer.pushAll(PojoIndexingProcessorPropertyNodeBuilder::closeOnFailure, this.propertyNodeBuilders.values());
        }
    }

    public Optional<PojoIndexingProcessor<T>> build(PojoIndexingDependencyCollectorTypeNode<T> dependencyCollector) {
        try {
            return this.doBuild(dependencyCollector);
        }
        catch (RuntimeException e) {
            this.getFailureCollector().add((Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<PojoIndexingProcessor<T>> doBuild(PojoIndexingDependencyCollectorTypeNode<T> dependencyCollector) {
        if (this.boundRoutingKeyBridge != null) {
            this.boundRoutingKeyBridge.getPojoModelRootElement().contributeDependencies(dependencyCollector);
        }
        ArrayList immutablePropertyNodes = this.propertyNodeBuilders.isEmpty() ? Collections.emptyList() : new ArrayList(this.propertyNodeBuilders.size());
        try {
            ArrayList<BeanHolder<? extends TypeBridge>> immutableBridgeHolders = this.boundBridges.isEmpty() ? Collections.emptyList() : new ArrayList<BeanHolder<? extends TypeBridge>>();
            for (BoundTypeBridge<T> boundBridge : this.boundBridges) {
                immutableBridgeHolders.add(boundBridge.getBridgeHolder());
                boundBridge.getPojoModelRootElement().contributeDependencies(dependencyCollector);
            }
            this.propertyNodeBuilders.values().stream().map(builder -> builder.build(dependencyCollector)).filter(Optional::isPresent).map(Optional::get).forEach(immutablePropertyNodes::add);
            if (this.parentIndexObjectReferences.isEmpty() && immutableBridgeHolders.isEmpty() && immutablePropertyNodes.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new PojoIndexingProcessorTypeNode(this.parentIndexObjectReferences, immutableBridgeHolders, immutablePropertyNodes));
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(PojoIndexingProcessor::close, immutablePropertyNodes);
            throw e;
        }
    }
}

