/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.binding.MarkerBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.PropertyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.RoutingKeyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.TypeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public final class AnnotationInitializingBeanDelegatingBinder<A extends Annotation>
implements TypeBinder<A>,
PropertyBinder<A>,
RoutingKeyBinder<A>,
MarkerBinder<A> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanReference<?> delegateReference;
    private A annotation;

    public AnnotationInitializingBeanDelegatingBinder(BeanReference<?> delegateReference) {
        this.delegateReference = delegateReference;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegateReference=" + this.delegateReference + ", annotation=" + this.annotation + "]";
    }

    @Override
    public void initialize(A annotation) {
        this.annotation = annotation;
    }

    @Override
    public void bind(TypeBindingContext context) {
        try (BeanHolder<TypeBinder> delegateHolder = this.createDelegate(context.getBeanResolver(), TypeBinder.class);){
            TypeBinder castedDelegate = (TypeBinder)delegateHolder.get();
            castedDelegate.initialize(this.annotation);
            castedDelegate.bind(context);
        }
    }

    @Override
    public void bind(PropertyBindingContext context) {
        try (BeanHolder<PropertyBinder> delegateHolder = this.createDelegate(context.getBeanResolver(), PropertyBinder.class);){
            PropertyBinder castedDelegate = (PropertyBinder)delegateHolder.get();
            castedDelegate.initialize(this.annotation);
            castedDelegate.bind(context);
        }
    }

    @Override
    public void bind(RoutingKeyBindingContext context) {
        try (BeanHolder<RoutingKeyBinder> delegateHolder = this.createDelegate(context.getBeanResolver(), RoutingKeyBinder.class);){
            RoutingKeyBinder castedDelegate = (RoutingKeyBinder)delegateHolder.get();
            castedDelegate.initialize(this.annotation);
            castedDelegate.bind(context);
        }
    }

    @Override
    public void bind(MarkerBindingContext context) {
        try (BeanHolder<MarkerBinder> delegateHolder = this.createDelegate(context.getBeanResolver(), MarkerBinder.class);){
            MarkerBinder castedDelegate = (MarkerBinder)delegateHolder.get();
            castedDelegate.initialize(this.annotation);
            castedDelegate.bind(context);
        }
    }

    private <B> BeanHolder<? extends B> createDelegate(BeanResolver beanResolver, Class<B> expectedType) {
        BeanHolder delegateHolder = this.delegateReference.asSubTypeOf(expectedType).resolve(beanResolver);
        try {
            Object delegate = delegateHolder.get();
            Class<? extends Annotation> annotationType = this.annotation.annotationType();
            GenericTypeContext bridgeTypeContext = new GenericTypeContext(delegate.getClass());
            Class binderAnnotationType = bridgeTypeContext.resolveTypeArgument(expectedType, 0).map(ReflectionUtils::getRawType).orElseThrow(() -> new AssertionFailure("Could not auto-detect the annotation type accepted by binder '" + delegate + "'. There is a bug in Hibernate Search, please report it."));
            if (!binderAnnotationType.isAssignableFrom(annotationType)) {
                throw log.invalidAnnotationTypeForBinder(delegate, annotationType);
            }
            return delegateHolder;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)delegateHolder);
            throw e;
        }
    }
}

