/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeMappingStepImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;

public class ProgrammaticMappingConfigurationContextImpl
implements ProgrammaticMappingConfigurationContext,
PojoMappingConfigurationContributor {
    private final PojoBootstrapIntrospector introspector;
    private final Map<Class<?>, TypeMappingStepImpl> typeMappingContributors = new LinkedHashMap();

    public ProgrammaticMappingConfigurationContextImpl(PojoBootstrapIntrospector introspector) {
        this.introspector = introspector;
    }

    @Override
    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        for (TypeMappingStepImpl typeMappingContributor : this.typeMappingContributors.values()) {
            typeMappingContributor.configure(buildContext, configurationCollector);
        }
    }

    @Override
    public TypeMappingStep type(Class<?> clazz) {
        return this.typeMappingContributors.computeIfAbsent(clazz, c -> new TypeMappingStepImpl(this.introspector.getTypeModel(c)));
    }
}

