/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeContainedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContextProvider;
import org.hibernate.search.util.common.impl.Closer;

public class PojoContainedTypeManagerContainer
implements PojoWorkContainedTypeContextProvider,
PojoScopeContainedTypeContextProvider {
    private final Map<Class<?>, PojoContainedTypeManager<?>> byExactClass;
    private final Set<PojoContainedTypeManager<?>> all;

    public static Builder builder() {
        return new Builder();
    }

    private PojoContainedTypeManagerContainer(Builder builder) {
        this.byExactClass = new HashMap(builder.byExactClass);
        this.all = Collections.unmodifiableSet(new LinkedHashSet(this.byExactClass.values()));
    }

    public <E> Optional<PojoContainedTypeManager<E>> getByExactClass(Class<E> clazz) {
        return Optional.ofNullable(this.byExactClass.get(clazz));
    }

    Set<PojoContainedTypeManager<?>> getAll() {
        return this.all;
    }

    public static class Builder {
        private final Map<Class<?>, PojoContainedTypeManager<?>> byExactClass = new LinkedHashMap();

        private Builder() {
        }

        public <E> void add(PojoRawTypeModel<E> typeModel, PojoContainedTypeManager<E> typeManager) {
            this.byExactClass.put(typeModel.getJavaClass(), typeManager);
        }

        public void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.pushAll(PojoContainedTypeManager::close, this.byExactClass.values());
            }
        }

        public PojoContainedTypeManagerContainer build() {
            return new PojoContainedTypeManagerContainer(this);
        }
    }
}

