/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.util.Collection;
import java.util.Optional;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoProcessorNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorContainerElementNode;
import org.hibernate.search.util.common.impl.Closer;

class PojoIndexingProcessorContainerElementNodeBuilder<P extends C, C, V>
extends AbstractPojoProcessorNodeBuilder {
    private final BoundPojoModelPathValueNode<?, P, V> modelPath;
    private final ContainerExtractorHolder<C, V> extractorHolder;
    private final PojoIndexingProcessorValueNodeBuilderDelegate<P, V> valueNodeProcessorCollectionBuilder;

    PojoIndexingProcessorContainerElementNodeBuilder(BoundPojoModelPathValueNode<?, P, V> modelPath, ContainerExtractorHolder<C, V> extractorHolder, PojoMappingHelper mappingHelper, IndexBindingContext bindingContext) {
        super(mappingHelper, bindingContext);
        this.modelPath = modelPath;
        this.extractorHolder = extractorHolder;
        this.valueNodeProcessorCollectionBuilder = new PojoIndexingProcessorValueNodeBuilderDelegate<P, V>(modelPath, mappingHelper, bindingContext, extractorHolder.get().isMultiValued());
    }

    public PojoMappingCollectorValueNode value() {
        return this.valueNodeProcessorCollectionBuilder;
    }

    @Override
    BoundPojoModelPathValueNode<?, ? extends C, V> getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(ContainerExtractorHolder::close, (Object[])new ContainerExtractorHolder[]{this.extractorHolder});
            closer.pushAll(PojoIndexingProcessorValueNodeBuilderDelegate::closeOnFailure, (Object[])new PojoIndexingProcessorValueNodeBuilderDelegate[]{this.valueNodeProcessorCollectionBuilder});
        }
    }

    Optional<PojoIndexingProcessorContainerElementNode<C, V>> build(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        try {
            return this.doBuild(parentDependencyCollector);
        }
        catch (RuntimeException e) {
            this.getFailureCollector().add((Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<PojoIndexingProcessorContainerElementNode<C, V>> doBuild(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        Collection immutableNestedProcessors = this.valueNodeProcessorCollectionBuilder.build(parentDependencyCollector);
        if (immutableNestedProcessors.isEmpty()) {
            this.extractorHolder.close();
            return Optional.empty();
        }
        return Optional.of(new PojoIndexingProcessorContainerElementNode(this.extractorHolder, immutableNestedProcessors));
    }
}

