/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.FieldModelContributorBridgeContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PojoIndexSchemaContributionListener;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PojoValueBridgeFromDocumentFieldValueConverter;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PojoValueBridgeToDocumentFieldValueConverter;
import org.hibernate.search.mapper.pojo.bridge.binding.spi.FieldModelContributor;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelValueElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public class ValueBindingContextImpl<V>
extends AbstractBindingContext
implements ValueBindingContext<V> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoGenericTypeModel<V> valueTypeModel;
    private final boolean multiValued;
    private final PojoModelValue<V> bridgedElement;
    private final IndexFieldTypeFactory indexFieldTypeFactory;
    private final PojoIndexSchemaContributionListener listener;
    private final IndexSchemaElement schemaElement;
    private final String relativeFieldName;
    private final FieldModelContributor contributor;
    private PartialBinding<V, ?> partialBinding;

    public ValueBindingContextImpl(BeanResolver beanResolver, PojoGenericTypeModel<V> valueTypeModel, boolean multiValued, IndexBindingContext indexBindingContext, IndexFieldTypeDefaultsProvider defaultsProvider, String relativeFieldName, FieldModelContributor contributor) {
        super(beanResolver);
        this.valueTypeModel = valueTypeModel;
        this.multiValued = multiValued;
        this.bridgedElement = new PojoModelValueElement<V>(valueTypeModel);
        this.indexFieldTypeFactory = indexBindingContext.createTypeFactory(defaultsProvider);
        this.listener = new PojoIndexSchemaContributionListener();
        this.schemaElement = indexBindingContext.getSchemaElement((IndexSchemaContributionListener)this.listener);
        this.relativeFieldName = relativeFieldName;
        this.contributor = contributor;
    }

    @Override
    public <V2, F> void setBridge(Class<V2> expectedValueType, ValueBridge<V2, F> bridge) {
        this.setBridge(expectedValueType, bridge, null);
    }

    @Override
    public <V2, F> void setBridge(Class<V2> expectedValueType, ValueBridge<V2, F> bridge, StandardIndexFieldTypeOptionsStep<?, F> fieldTypeOptionsStep) {
        this.setBridge(expectedValueType, BeanHolder.of(bridge), fieldTypeOptionsStep);
    }

    @Override
    public <V2, F> void setBridge(Class<V2> expectedValueType, BeanHolder<? extends ValueBridge<V2, F>> bridgeHolder, StandardIndexFieldTypeOptionsStep<?, F> fieldTypeOptionsStep) {
        try {
            if (!this.valueTypeModel.getRawType().isSubTypeOf(expectedValueType)) {
                throw log.invalidInputTypeForBridge(bridgeHolder.get(), this.valueTypeModel);
            }
            IndexFieldReference<F> indexFieldReference = this.createFieldReference(expectedValueType, (ValueBridge)bridgeHolder.get(), fieldTypeOptionsStep);
            BeanHolder<? extends ValueBridge<V2, F>> castedBridgeHolder = bridgeHolder;
            this.partialBinding = new PartialBinding(castedBridgeHolder, indexFieldReference);
        }
        catch (RuntimeException e) {
            ValueBindingContextImpl.abortBridge(new SuppressingCloser((Throwable)e), bridgeHolder);
            throw e;
        }
    }

    @Override
    public PojoModelValue<V> getBridgedElement() {
        return this.bridgedElement;
    }

    @Override
    public IndexFieldTypeFactory getTypeFactory() {
        return this.indexFieldTypeFactory;
    }

    public Optional<BoundValueBridge<V, ?>> applyBinder(ValueBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw log.missingBridgeForBinder(binder);
            }
            if (!this.listener.isAnySchemaContributed()) {
                try (Object closer = new Closer();){
                    this.partialBinding.abort((AbstractCloser<?, ?>)closer);
                }
                closer = Optional.empty();
                return closer;
            }
            Optional<BoundValueBridge<V, ?>> closer = Optional.of(this.partialBinding.complete());
            return closer;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private <V2, F> IndexFieldReference<F> createFieldReference(Class<V2> expectedValueType, ValueBridge<V2, F> bridge, StandardIndexFieldTypeOptionsStep<?, F> fieldTypeOptionsStep) {
        if (fieldTypeOptionsStep == null) {
            fieldTypeOptionsStep = this.inferFieldType(bridge);
        }
        fieldTypeOptionsStep.dslConverter(new PojoValueBridgeToDocumentFieldValueConverter<V2, F>(bridge, expectedValueType));
        fieldTypeOptionsStep.projectionConverter(new PojoValueBridgeFromDocumentFieldValueConverter<F, V2>(bridge, expectedValueType));
        this.contributor.contribute((StandardIndexFieldTypeOptionsStep<?, ?>)fieldTypeOptionsStep, new FieldModelContributorBridgeContextImpl<F>(bridge, fieldTypeOptionsStep));
        IndexSchemaFieldOptionsStep fieldContext = this.schemaElement.field(this.relativeFieldName, fieldTypeOptionsStep);
        if (this.multiValued) {
            fieldContext.multiValued();
        }
        return (IndexFieldReference)fieldContext.toReference();
    }

    private <F> StandardIndexFieldTypeOptionsStep<?, F> inferFieldType(ValueBridge<?, F> bridge) {
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(bridge.getClass());
        Class returnType = bridgeTypeContext.resolveTypeArgument(ValueBridge.class, 1).map(ReflectionUtils::getRawType).orElseThrow(() -> new AssertionFailure("Could not auto-detect the return type for value bridge '" + bridge + "'. There is a bug in Hibernate Search, please report it."));
        return this.indexFieldTypeFactory.as(returnType);
    }

    private static void abortBridge(AbstractCloser<?, ?> closer, BeanHolder<? extends ValueBridge<?, ?>> bridgeHolder) {
        closer.push(holder -> ((ValueBridge)holder.get()).close(), bridgeHolder);
        closer.push(BeanHolder::close, bridgeHolder);
    }

    private static class PartialBinding<V, F> {
        private final BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder;
        private final IndexFieldReference<F> indexFieldReference;

        private PartialBinding(BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder, IndexFieldReference<F> indexFieldReference) {
            this.bridgeHolder = bridgeHolder;
            this.indexFieldReference = indexFieldReference;
        }

        void abort(AbstractCloser<?, ?> closer) {
            ValueBindingContextImpl.abortBridge(closer, this.bridgeHolder);
        }

        BoundValueBridge<V, F> complete() {
            return new BoundValueBridge(this.bridgeHolder, this.indexFieldReference);
        }
    }
}

