/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.mapping.impl;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.binding.IdentifierBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;

public final class BeanDelegatingBinder
implements IdentifierBinder,
ValueBinder {
    private final BeanReference<?> delegateReference;

    public BeanDelegatingBinder(BeanReference<?> delegateReference) {
        this.delegateReference = delegateReference;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegateReference=" + this.delegateReference + "]";
    }

    @Override
    public void bind(IdentifierBindingContext<?> context) {
        try (BeanHolder<IdentifierBinder> delegateHolder = this.createDelegate(context.getBeanResolver(), IdentifierBinder.class);){
            ((IdentifierBinder)delegateHolder.get()).bind(context);
        }
    }

    @Override
    public void bind(ValueBindingContext<?> context) {
        try (BeanHolder<ValueBinder> delegateHolder = this.createDelegate(context.getBeanResolver(), ValueBinder.class);){
            ((ValueBinder)delegateHolder.get()).bind(context);
        }
    }

    private <B> BeanHolder<? extends B> createDelegate(BeanResolver beanResolver, Class<B> expectedType) {
        return this.delegateReference.asSubTypeOf(expectedType).resolve(beanResolver);
    }
}

