/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.IdentifierBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.IdentifierBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.MarkerBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.PropertyBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.RoutingKeyBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.TypeBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.MarkerBinding;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.PropertyBinding;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.RoutingKeyBinding;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.declaration.TypeBinding;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.AnnotationInitializingBeanDelegatingBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanDelegatingBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.IdentifierBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.annotation.ContainerExtract;
import org.hibernate.search.mapper.pojo.extractor.mapping.annotation.ContainerExtraction;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.DocumentId;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ObjectPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.PropertyValue;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class AnnotationProcessorHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final FailureCollector rootFailureCollector;

    AnnotationProcessorHelper(FailureCollector rootFailureCollector) {
        this.rootFailureCollector = rootFailureCollector;
    }

    FailureCollector getRootFailureCollector() {
        return this.rootFailureCollector;
    }

    Optional<PojoModelPathValueNode> getPojoModelPathValueNode(ObjectPath objectPath) {
        PropertyValue[] inversePathElements = objectPath.value();
        PojoModelPath.Builder inversePathBuilder = PojoModelPath.builder();
        for (PropertyValue element : inversePathElements) {
            String inversePropertyName = element.propertyName();
            ContainerExtractorPath inverseExtractorPath = this.getExtractorPath(element.extraction());
            inversePathBuilder.property(inversePropertyName).value(inverseExtractorPath);
        }
        return Optional.ofNullable(inversePathBuilder.toValuePathOrNull());
    }

    ContainerExtractorPath getExtractorPath(ContainerExtraction extraction) {
        ContainerExtract extract = extraction.extract();
        String[] extractors = extraction.value();
        switch (extract) {
            case NO: {
                if (extractors.length != 0) {
                    throw log.cannotReferenceExtractorsWhenExtractionDisabled();
                }
                return ContainerExtractorPath.noExtractors();
            }
            case DEFAULT: {
                if (extractors.length == 0) {
                    return ContainerExtractorPath.defaultExtractors();
                }
                return ContainerExtractorPath.explicitExtractors(Arrays.asList(extractors));
            }
        }
        throw new AssertionFailure("Unexpected " + ContainerExtract.class.getSimpleName() + " value: " + (Object)((Object)extract));
    }

    <A extends Annotation> MarkerBinder createMarkerBinder(A annotation) {
        MarkerBinding markerBinding = annotation.annotationType().getAnnotation(MarkerBinding.class);
        MarkerBinderRef binderReferenceAnnotation = markerBinding.binder();
        Optional<BeanReference<MarkerBinder<?>>> binderReference = this.toBeanReference(MarkerBinder.class, MarkerBinderRef.UndefinedBinderImplementationType.class, binderReferenceAnnotation.type(), binderReferenceAnnotation.name());
        if (!binderReference.isPresent()) {
            throw log.missingBinderReferenceInMarkerMapping(MarkerBinding.class, annotation.annotationType());
        }
        AnnotationInitializingBeanDelegatingBinder<A> binder = new AnnotationInitializingBeanDelegatingBinder<A>(binderReference.get());
        binder.initialize(annotation);
        return binder;
    }

    IdentifierBinder createIdentifierBinder(DocumentId annotation, PojoPropertyModel<?> annotationHolder) {
        IdentifierBridgeRef bridgeReferenceAnnotation = annotation.identifierBridge();
        IdentifierBinderRef binderReferenceAnnotation = annotation.identifierBinder();
        Optional<BeanReference<? extends IdentifierBridge>> bridgeReference = this.toBeanReference(IdentifierBridge.class, IdentifierBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name());
        Optional<BeanReference<? extends IdentifierBinder>> binderReference = this.toBeanReference(IdentifierBinder.class, IdentifierBinderRef.UndefinedBinderImplementationType.class, binderReferenceAnnotation.type(), binderReferenceAnnotation.name());
        if (bridgeReference.isPresent() && binderReference.isPresent()) {
            throw log.invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference(annotationHolder.getName());
        }
        if (bridgeReference.isPresent()) {
            return new BeanBinder(bridgeReference.get());
        }
        if (binderReference.isPresent()) {
            return new BeanDelegatingBinder(binderReference.get());
        }
        return null;
    }

    <A extends Annotation> RoutingKeyBinder createRoutingKeyBinder(A annotation) {
        RoutingKeyBinding bridgeMapping = annotation.annotationType().getAnnotation(RoutingKeyBinding.class);
        RoutingKeyBinderRef bridgeReferenceAnnotation = bridgeMapping.binder();
        Optional<BeanReference<RoutingKeyBinder<?>>> binderReference = this.toBeanReference(RoutingKeyBinder.class, RoutingKeyBinderRef.UndefinedBinderImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name());
        if (!binderReference.isPresent()) {
            throw log.missingBinderReferenceInBridgeMapping(bridgeMapping.annotationType(), annotation.annotationType());
        }
        AnnotationInitializingBeanDelegatingBinder<A> binder = new AnnotationInitializingBeanDelegatingBinder<A>(binderReference.get());
        binder.initialize(annotation);
        return binder;
    }

    <A extends Annotation> TypeBinder createTypeBinder(A annotation) {
        TypeBinding bridgeMapping = annotation.annotationType().getAnnotation(TypeBinding.class);
        TypeBinderRef bridgeReferenceAnnotation = bridgeMapping.binder();
        Optional<BeanReference<TypeBinder<?>>> binderReference = this.toBeanReference(TypeBinder.class, TypeBinderRef.UndefinedBinderImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name());
        if (!binderReference.isPresent()) {
            throw log.missingBinderReferenceInBridgeMapping(bridgeMapping.annotationType(), annotation.annotationType());
        }
        AnnotationInitializingBeanDelegatingBinder<A> binder = new AnnotationInitializingBeanDelegatingBinder<A>(binderReference.get());
        binder.initialize(annotation);
        return binder;
    }

    <A extends Annotation> PropertyBinder createPropertyBinder(A annotation) {
        PropertyBinding bridgeMapping = annotation.annotationType().getAnnotation(PropertyBinding.class);
        PropertyBinderRef bridgeReferenceAnnotation = bridgeMapping.binder();
        Optional<BeanReference<PropertyBinder<?>>> binderReference = this.toBeanReference(PropertyBinder.class, PropertyBinderRef.UndefinedBinderImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name());
        if (!binderReference.isPresent()) {
            throw log.missingBinderReferenceInBridgeMapping(bridgeMapping.annotationType(), annotation.annotationType());
        }
        AnnotationInitializingBeanDelegatingBinder<A> binder = new AnnotationInitializingBeanDelegatingBinder<A>(binderReference.get());
        binder.initialize(annotation);
        return binder;
    }

    ValueBinder createValueBinder(ValueBridgeRef bridgeReferenceAnnotation, ValueBinderRef binderReferenceAnnotation, PojoPropertyModel<?> annotationHolder) {
        Optional<BeanReference<? extends ValueBridge>> bridgeReference = this.toBeanReference(ValueBridge.class, ValueBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name());
        Optional<BeanReference<? extends ValueBinder>> binderReference = this.toBeanReference(ValueBinder.class, ValueBinderRef.UndefinedBinderImplementationType.class, binderReferenceAnnotation.type(), binderReferenceAnnotation.name());
        if (bridgeReference.isPresent() && binderReference.isPresent()) {
            throw log.invalidFieldDefiningBothBridgeReferenceAndBinderReference(annotationHolder.getName());
        }
        if (bridgeReference.isPresent()) {
            return new BeanBinder(bridgeReference.get());
        }
        if (binderReference.isPresent()) {
            return new BeanDelegatingBinder(binderReference.get());
        }
        return null;
    }

    private <T> Optional<BeanReference<? extends T>> toBeanReference(Class<T> expectedType, Class<?> undefinedTypeMarker, Class<? extends T> type, String name) {
        Class<? extends T> cleanedUpType;
        String cleanedUpName = name.isEmpty() ? null : name;
        Class<? extends T> clazz = cleanedUpType = undefinedTypeMarker.equals(type) ? null : type;
        if (cleanedUpName == null && cleanedUpType == null) {
            return Optional.empty();
        }
        Class<Object> defaultedType = cleanedUpType == null ? expectedType : cleanedUpType;
        return Optional.of(BeanReference.of(defaultedType, (String)cleanedUpName));
    }
}

