/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeContainedTypeContext;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.mapper.pojo.work.impl.CachingCastingEntitySupplier;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.util.common.impl.ToStringTreeAppendable;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoContainedTypeManager<E>
implements AutoCloseable,
ToStringTreeAppendable,
PojoWorkContainedTypeContext<E>,
PojoScopeContainedTypeContext<E> {
    private final Class<E> javaClass;
    private final PojoCaster<E> caster;
    private final PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver;

    public PojoContainedTypeManager(Class<E> javaClass, PojoCaster<E> caster, PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver) {
        this.javaClass = javaClass;
        this.caster = caster;
        this.reindexingResolver = reindexingResolver;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[javaType = " + this.javaClass + "]";
    }

    @Override
    public void close() {
        this.reindexingResolver.close();
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("javaClass", this.javaClass).attribute("reindexingResolver", this.reindexingResolver);
    }

    @Override
    public Class<E> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public Supplier<E> toEntitySupplier(AbstractPojoBackendSessionContext sessionContext, Object entity) {
        PojoRuntimeIntrospector introspector = sessionContext.getRuntimeIntrospector();
        return new CachingCastingEntitySupplier<E>(this.caster, introspector, entity);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, Supplier<E> entitySupplier, Set<String> dirtyPaths) {
        this.reindexingResolver.resolveEntitiesToReindex(collector, runtimeIntrospector, entitySupplier.get(), dirtyPaths);
    }

    @Override
    public PojoContainedTypeIndexingPlan<E> createIndexingPlan(AbstractPojoBackendSessionContext sessionContext) {
        return new PojoContainedTypeIndexingPlan(this, sessionContext);
    }
}

