/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import java.util.Collection;
import java.util.stream.Stream;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorContainerElementNode<C, V>
extends PojoIndexingProcessor<C> {
    private final ContainerExtractorHolder<C, V> extractorHolder;
    private final Collection<PojoIndexingProcessor<? super V>> nestedNodes;

    public PojoIndexingProcessorContainerElementNode(ContainerExtractorHolder<C, V> extractorHolder, Collection<PojoIndexingProcessor<? super V>> nestedNodes) {
        this.extractorHolder = extractorHolder;
        this.nestedNodes = nestedNodes;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ContainerExtractorHolder::close, this.extractorHolder);
            closer.pushAll(PojoIndexingProcessor::close, this.nestedNodes);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("extractor", this.extractorHolder.get());
        builder.startList("nestedNodes");
        for (PojoIndexingProcessor<? super V> pojoIndexingProcessor : this.nestedNodes) {
            builder.value(pojoIndexingProcessor);
        }
        builder.endList();
    }

    @Override
    public final void process(DocumentElement target, C source, AbstractPojoBackendSessionContext sessionContext) {
        try (Stream<V> stream = this.extractorHolder.get().extract(source);){
            stream.forEach(sourceItem -> this.processItem(target, sourceItem, sessionContext));
        }
    }

    private void processItem(DocumentElement target, V sourceItem, AbstractPojoBackendSessionContext sessionContext) {
        for (PojoIndexingProcessor<V> nestedNode : this.nestedNodes) {
            nestedNode.process(target, sourceItem, sessionContext);
        }
    }
}

