/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoContainedTypeIndexingPlan<E>
extends AbstractPojoTypeIndexingPlan {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkContainedTypeContext<E> typeContext;
    private final Map<Object, ContainedEntityIndexingPlan> indexingPlansPerId = new LinkedHashMap<Object, ContainedEntityIndexingPlan>();

    public PojoContainedTypeIndexingPlan(PojoWorkContainedTypeContext<E> typeContext, AbstractPojoBackendSessionContext sessionContext) {
        super(sessionContext);
        this.typeContext = typeContext;
    }

    @Override
    void add(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        this.getPlan(providedId).add(entitySupplier);
    }

    @Override
    void update(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        this.getPlan(providedId).update(entitySupplier);
    }

    @Override
    void update(Object providedId, Object entity, String ... dirtyPaths) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        this.getPlan(providedId).update(entitySupplier, dirtyPaths);
    }

    @Override
    void delete(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeContext.toEntitySupplier(this.sessionContext, entity);
        this.getPlan(providedId).delete(entitySupplier);
    }

    @Override
    void purge(Object providedId) {
        throw log.cannotPurgeNonIndexedContainedType(this.typeContext.getJavaClass(), providedId);
    }

    void resolveDirty(PojoReindexingCollector containingEntityCollector) {
        for (ContainedEntityIndexingPlan plan : this.indexingPlansPerId.values()) {
            plan.resolveDirty(containingEntityCollector);
        }
    }

    private ContainedEntityIndexingPlan getPlan(Object identifier) {
        ContainedEntityIndexingPlan plan = this.indexingPlansPerId.get(identifier);
        if (plan == null) {
            plan = new ContainedEntityIndexingPlan();
            this.indexingPlansPerId.put(identifier, plan);
        }
        return plan;
    }

    private class ContainedEntityIndexingPlan {
        private Supplier<E> entitySupplier;
        private Boolean createdInThisPlan;
        private boolean shouldResolveToReindex;
        private boolean considerAllDirty;
        private Set<String> dirtyPaths;

        private ContainedEntityIndexingPlan() {
        }

        void add(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            this.shouldResolveToReindex = true;
            if (this.createdInThisPlan == null) {
                this.createdInThisPlan = true;
            }
        }

        void update(Supplier<E> entitySupplier) {
            this.doUpdate(entitySupplier);
            this.shouldResolveToReindex = true;
            this.considerAllDirty = true;
            this.dirtyPaths = null;
        }

        void update(Supplier<E> entitySupplier, String ... dirtyPaths) {
            this.doUpdate(entitySupplier);
            this.shouldResolveToReindex = true;
            if (!this.considerAllDirty) {
                for (String dirtyPath : dirtyPaths) {
                    this.addDirtyPath(dirtyPath);
                }
            }
        }

        void delete(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (this.createdInThisPlan == null) {
                this.createdInThisPlan = false;
            } else if (this.createdInThisPlan.booleanValue()) {
                this.shouldResolveToReindex = false;
                this.considerAllDirty = false;
                this.dirtyPaths = null;
                this.createdInThisPlan = null;
            }
        }

        void resolveDirty(PojoReindexingCollector containingEntityCollector) {
            if (this.shouldResolveToReindex) {
                this.shouldResolveToReindex = false;
                PojoContainedTypeIndexingPlan.this.typeContext.resolveEntitiesToReindex(containingEntityCollector, PojoContainedTypeIndexingPlan.this.sessionContext.getRuntimeIntrospector(), this.entitySupplier, this.considerAllDirty ? null : this.dirtyPaths);
            }
        }

        private void doUpdate(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (this.createdInThisPlan == null) {
                this.createdInThisPlan = false;
            }
        }

        private void addDirtyPath(String dirtyPath) {
            if (this.dirtyPaths == null) {
                this.dirtyPaths = new HashSet<String>();
            }
            this.dirtyPaths.add(dirtyPath);
        }
    }
}

