/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.mapper.pojo.work.impl.AbstractPojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoContainedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingPlanImpl
implements PojoIndexingPlan {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoWorkIndexedTypeContextProvider indexedTypeContextProvider;
    private final PojoWorkContainedTypeContextProvider containedTypeContextProvider;
    private final AbstractPojoBackendSessionContext sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private final Map<Class<?>, PojoIndexedTypeIndexingPlan<?, ?, ?>> indexedTypeDelegates = new LinkedHashMap();
    private final Map<Class<?>, PojoContainedTypeIndexingPlan<?>> containedTypeDelegates = new HashMap();
    private boolean isProcessing = false;

    public PojoIndexingPlanImpl(PojoWorkIndexedTypeContextProvider indexedTypeContextProvider, PojoWorkContainedTypeContextProvider containedTypeContextProvider, AbstractPojoBackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.containedTypeContextProvider = containedTypeContextProvider;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.getRuntimeIntrospector();
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    @Override
    public void add(Object entity) {
        this.add(null, entity);
    }

    @Override
    public void add(Object providedId, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(clazz);
        delegate.add(providedId, entity);
    }

    @Override
    public void addOrUpdate(Object entity) {
        this.addOrUpdate(null, entity);
    }

    @Override
    public void addOrUpdate(Object providedId, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(clazz);
        delegate.update(providedId, entity);
    }

    @Override
    public void addOrUpdate(Object entity, String ... dirtyPaths) {
        this.addOrUpdate(null, entity, dirtyPaths);
    }

    @Override
    public void addOrUpdate(Object providedId, Object entity, String ... dirtyPaths) {
        Class<Object> clazz = this.getIntrospector().getClass(entity);
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(clazz);
        delegate.update(providedId, entity, dirtyPaths);
    }

    @Override
    public void delete(Object entity) {
        this.delete(null, entity);
    }

    @Override
    public void delete(Object providedId, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(clazz);
        delegate.delete(providedId, entity);
    }

    @Override
    public void purge(Class<?> clazz, Object providedId) {
        AbstractPojoTypeIndexingPlan delegate = this.getDelegate(clazz);
        delegate.purge(providedId);
    }

    @Override
    public void process() {
        if (this.isProcessing) {
            throw log.recursiveIndexingPlanProcess();
        }
        this.isProcessing = true;
        try {
            for (PojoContainedTypeIndexingPlan<?> pojoContainedTypeIndexingPlan : this.containedTypeDelegates.values()) {
                pojoContainedTypeIndexingPlan.resolveDirty(this::updateBecauseOfContained);
            }
            for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                pojoIndexedTypeIndexingPlan.resolveDirty(this::updateBecauseOfContained);
            }
            for (PojoIndexedTypeIndexingPlan pojoIndexedTypeIndexingPlan : this.indexedTypeDelegates.values()) {
                pojoIndexedTypeIndexingPlan.process();
            }
        }
        finally {
            this.isProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> execute() {
        try {
            this.process();
            ArrayList futures = new ArrayList();
            for (PojoIndexedTypeIndexingPlan<?, ?, ?> delegate : this.indexedTypeDelegates.values()) {
                futures.add(delegate.execute());
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return completableFuture;
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    @Override
    public void discard() {
        try {
            for (PojoIndexedTypeIndexingPlan<?, ?, ?> delegate : this.indexedTypeDelegates.values()) {
                delegate.discard();
            }
        }
        finally {
            this.indexedTypeDelegates.clear();
        }
    }

    @Override
    public void discardNotProcessed() {
        for (PojoIndexedTypeIndexingPlan<?, ?, ?> delegate : this.indexedTypeDelegates.values()) {
            delegate.discardNotProcessed();
        }
    }

    private PojoRuntimeIntrospector getIntrospector() {
        return this.introspector;
    }

    private AbstractPojoTypeIndexingPlan getDelegate(Class<?> clazz) {
        AbstractPojoTypeIndexingPlan delegate = this.indexedTypeDelegates.get(clazz);
        if (delegate == null && (delegate = (AbstractPojoTypeIndexingPlan)this.containedTypeDelegates.get(clazz)) == null) {
            delegate = this.createDelegate(clazz);
        }
        return delegate;
    }

    private AbstractPojoTypeIndexingPlan createDelegate(Class<?> clazz) {
        Optional<PojoWorkIndexedTypeContext<?, ?, ?>> indexedTypeContextOptional = this.indexedTypeContextProvider.getByExactClass(clazz);
        if (indexedTypeContextOptional.isPresent()) {
            PojoIndexedTypeIndexingPlan<?, ?, ?> delegate = indexedTypeContextOptional.get().createIndexingPlan(this.sessionContext, this.commitStrategy, this.refreshStrategy);
            this.indexedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        Optional<PojoWorkContainedTypeContext<?>> containedTypeContextOptional = this.containedTypeContextProvider.getByExactClass(clazz);
        if (containedTypeContextOptional.isPresent()) {
            PojoContainedTypeIndexingPlan<?> delegate = containedTypeContextOptional.get().createIndexingPlan(this.sessionContext);
            this.containedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        throw log.notIndexedTypeNorAsDelegate(clazz);
    }

    private PojoIndexedTypeIndexingPlan<?, ?, ?> getOrCreateIndexedDelegateForContainedUpdate(Class<?> clazz) {
        PojoIndexedTypeIndexingPlan<?, ?, ?> delegate = this.indexedTypeDelegates.get(clazz);
        if (delegate != null) {
            return delegate;
        }
        Optional<PojoWorkIndexedTypeContext<?, ?, ?>> indexedTypeManagerOptional = this.indexedTypeContextProvider.getByExactClass(clazz);
        if (indexedTypeManagerOptional.isPresent()) {
            delegate = indexedTypeManagerOptional.get().createIndexingPlan(this.sessionContext, this.commitStrategy, this.refreshStrategy);
            this.indexedTypeDelegates.put(clazz, delegate);
            return delegate;
        }
        throw new AssertionFailure("Attempt to reindex an entity of type " + clazz + " because a contained entity was modified, but " + clazz + " is not indexed directly. This is proa");
    }

    private void updateBecauseOfContained(Object containingEntity) {
        Class<Object> clazz = this.getIntrospector().getClass(containingEntity);
        PojoIndexedTypeIndexingPlan<?, ?, ?> delegate = this.getOrCreateIndexedDelegateForContainedUpdate(clazz);
        delegate.updateBecauseOfContained(containingEntity);
    }
}

