/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import org.hibernate.search.util.common.impl.ClosingOperator;

public abstract class AbstractCloser<S, E extends Exception> {
    public <T> S push(ClosingOperator<T, ? extends E> operator, T objectToClose) {
        try {
            if (objectToClose != null) {
                operator.close(objectToClose);
            }
        }
        catch (Throwable t) {
            this.getState().addThrowable(this, t);
        }
        return this.getSelf();
    }

    public <T> S pushAll(ClosingOperator<T, ? extends E> operator, Iterable<T> objectsToClose) {
        for (T objectToClose : objectsToClose) {
            this.push(operator, objectToClose);
        }
        return this.getSelf();
    }

    @SafeVarargs
    public final <T> S pushAll(ClosingOperator<T, ? extends E> operator, T ... objectsToClose) {
        for (T objectToClose : objectsToClose) {
            this.push(operator, objectToClose);
        }
        return this.getSelf();
    }

    abstract S getSelf();

    abstract State getState();

    static class State {
        AbstractCloser<?, ?> firstThrower;
        Throwable firstThrowable;

        State() {
        }

        void addThrowable(AbstractCloser<?, ?> source, Throwable throwable) {
            if (this.firstThrowable == null) {
                this.firstThrowable = throwable;
                this.firstThrower = source;
            } else {
                this.firstThrowable.addSuppressed(throwable);
            }
        }
    }
}

