/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.hibernate.search.util.common.impl.Futures;

class CancellableExecutionCompletableFuture<T>
extends CompletableFuture<T> {
    private final Future<?> future;

    CancellableExecutionCompletableFuture(Runnable runnable, ExecutorService executor) {
        this.future = executor.submit(new CompletingRunnable(this, runnable));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        super.cancel(mayInterruptIfRunning);
        return this.future.cancel(mayInterruptIfRunning);
    }

    private static class CompletingRunnable<T>
    implements Runnable {
        private final CompletableFuture<T> future;
        private final Runnable delegate;

        private CompletingRunnable(CompletableFuture<T> future, Runnable delegate) {
            this.future = future;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
                this.future.complete(null);
            }
            catch (Throwable t) {
                if (this.future.isCancelled()) {
                    Futures.getThrowableNow(this.future).addSuppressed(t);
                }
                this.future.completeExceptionally(t);
            }
        }
    }
}

