package org.hibernate.search.util.impl.common.logging;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Runnable;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void interruptedWorkError(final Runnable r) {
        super.log.logf(FQCN, ERROR, null, interruptedWorkError$str(), r);
    }
    private static final String interruptedWorkError = "HSEARCH000017: Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    protected String interruptedWorkError$str() {
        return interruptedWorkError;
    }
    @Override
    public final void exceptionOccurred(final String errorMsg, final Throwable exceptionThatOccurred) {
        super.log.logf(FQCN, ERROR, exceptionThatOccurred, exceptionOccurred$str(), errorMsg);
    }
    private static final String exceptionOccurred = "HSEARCH000058: %1$s";
    protected String exceptionOccurred$str() {
        return exceptionOccurred;
    }
    private static final String mustNotBeNull = "HSEARCH900000: '%1$s' must not be null.";
    protected String mustNotBeNull$str() {
        return mustNotBeNull;
    }
    @Override
    public final IllegalArgumentException mustNotBeNull(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mustNotBeNull$str(), objectDescription));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String collectionMustNotBeNullNorEmpty = "HSEARCH900001: '%1$s' must not be null or empty.";
    protected String collectionMustNotBeNullNorEmpty$str() {
        return collectionMustNotBeNullNorEmpty;
    }
    @Override
    public final IllegalArgumentException collectionMustNotBeNullNorEmpty(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), collectionMustNotBeNullNorEmpty$str(), objectDescription));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustBePositiveOrZero = "HSEARCH900002: '%1$s' must be positive or zero.";
    protected String mustBePositiveOrZero$str() {
        return mustBePositiveOrZero;
    }
    @Override
    public final IllegalArgumentException mustBePositiveOrZero(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mustBePositiveOrZero$str(), objectDescription));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String stringMustNotBeNullNorEmpty = "HSEARCH900003: '%1$s' must not be null or empty.";
    protected String stringMustNotBeNullNorEmpty$str() {
        return stringMustNotBeNullNorEmpty;
    }
    @Override
    public final IllegalArgumentException stringMustNotBeNullNorEmpty(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), stringMustNotBeNullNorEmpty$str(), objectDescription));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String arrayMustNotBeNullNorEmpty = "HSEARCH900004: '%1$s' must not be null or empty.";
    protected String arrayMustNotBeNullNorEmpty$str() {
        return arrayMustNotBeNullNorEmpty;
    }
    @Override
    public final IllegalArgumentException arrayMustNotBeNullNorEmpty(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), arrayMustNotBeNullNorEmpty$str(), objectDescription));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
