/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import org.hibernate.search.util.EventContext;

public class SearchException
extends RuntimeException {
    private final String messageWithoutContext;
    private final EventContext context;

    public SearchException(String message, Throwable cause) {
        super(message, cause);
        this.messageWithoutContext = message;
        this.context = null;
    }

    public SearchException(String message) {
        this(message, (Throwable)null);
    }

    public SearchException(Throwable cause) {
        this(null, cause);
    }

    public SearchException(String message, Throwable cause, EventContext context) {
        super(message + "\n" + context.render(), cause);
        this.messageWithoutContext = message;
        this.context = context;
    }

    public SearchException(String message, EventContext context) {
        this(message, null, context);
    }

    public SearchException(Throwable cause, EventContext context) {
        this(null, cause, context);
    }

    public String getMessageWithoutContext() {
        return this.messageWithoutContext;
    }

    public EventContext getContext() {
        return this.context;
    }
}

