/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl.common;

import org.hibernate.search.util.impl.common.AbstractCloser;

public final class Closer<E extends Exception>
extends AbstractCloser<Closer<E>, E>
implements AutoCloseable {
    private final CloseableState state;

    public Closer() {
        this(new CloseableState());
    }

    private Closer(CloseableState state) {
        this.state = state;
    }

    public <E2 extends Exception> Closer<E2> split() {
        return new Closer<E>(this.state);
    }

    @Override
    public void close() throws E {
        this.state.close(this);
    }

    @Override
    CloseableState getState() {
        return this.state;
    }

    @Override
    Closer<E> getSelf() {
        return this;
    }

    static class CloseableState
    extends AbstractCloser.State {
        CloseableState() {
        }

        <E extends Exception> void close(Closer<E> source) throws E {
            if (this.firstThrowable != null && source == this.firstThrower) {
                try {
                    if (this.firstThrowable instanceof RuntimeException) {
                        throw (RuntimeException)this.firstThrowable;
                    }
                    if (this.firstThrowable instanceof Error) {
                        throw (Error)this.firstThrowable;
                    }
                    throw (Exception)this.firstThrowable;
                }
                catch (Throwable throwable) {
                    this.firstThrower = null;
                    this.firstThrowable = null;
                    throw throwable;
                }
            }
        }
    }
}

