/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class StringHelper {
    private StringHelper() {
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String join(Object[] array, String separator) {
        return array != null ? StringHelper.join(Arrays.asList(array), separator) : null;
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object object : iterable) {
            if (!isFirst) {
                sb.append(separator);
            } else {
                isFirst = false;
            }
            sb.append(object);
        }
        return sb.toString();
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            if (!isFirst) {
                sb.append(separator);
            } else {
                isFirst = false;
            }
            sb.append(iterator.next());
        }
        return sb.toString();
    }

    public static <T> T parseDiscreteValues(T[] allowedValues, Function<T, String> stringRepresentationFunction, BiFunction<String, List<String>, RuntimeException> invalidValueFunction, String value) {
        String normalizedValue = value.trim().toLowerCase(Locale.ROOT);
        for (T candidate : allowedValues) {
            if (!stringRepresentationFunction.apply(candidate).equals(normalizedValue)) continue;
            return candidate;
        }
        throw invalidValueFunction.apply(normalizedValue, Arrays.stream(allowedValues).map(stringRepresentationFunction).collect(Collectors.toList()));
    }
}

