/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl.common;

import org.hibernate.search.util.AssertionFailure;

public final class Throwables {
    private Throwables() {
    }

    public static RuntimeException expectRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable == null) {
            throw new AssertionFailure("Null throwable - there is probably a bug");
        }
        throw new AssertionFailure("Unexpected throwable type - there is probably a bug", throwable);
    }

    public static Exception expectException(Throwable throwable) {
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable == null) {
            throw new AssertionFailure("Null throwable - there is probably a bug");
        }
        throw new AssertionFailure("Unexpected throwable type - there is probably a bug", throwable);
    }

    public static <T extends Throwable> T combine(T throwable, T otherThrowable) {
        T toThrow = throwable;
        if (otherThrowable != null) {
            if (toThrow != null) {
                toThrow.addSuppressed(otherThrowable);
            } else {
                toThrow = otherThrowable;
            }
        }
        return toThrow;
    }

    public static String getFirstNonNullMessage(Throwable t) {
        Throwable cause = t.getCause();
        while (t.getMessage() == null && cause != null) {
            t = cause;
            cause = t.getCause();
        }
        return t.getMessage();
    }
}

