/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl.common;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.logging.Log;

public final class Contracts {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());

    private Contracts() {
    }

    public static void assertNotNull(Object object, String objectDescription) {
        if (object == null) {
            throw log.mustNotBeNull(objectDescription);
        }
    }

    public static void assertNotNullNorEmpty(Collection<?> object, String objectDescription) {
        if (object == null || object.isEmpty()) {
            throw log.collectionMustNotBeNullNorEmpty(objectDescription);
        }
    }

    public static void assertNotNullNorEmpty(Object[] object, String objectDescription) {
        if (object == null || object.length == 0) {
            throw log.arrayMustNotBeNullNorEmpty(objectDescription);
        }
    }

    public static void assertPositiveOrZero(int number, String objectDescription) {
        if (number < 0) {
            throw log.mustBePositiveOrZero(objectDescription);
        }
    }

    public static void assertNotNullNorEmpty(String object, String objectDescription) {
        if (object == null || object.isEmpty()) {
            throw log.stringMustNotBeNullNorEmpty(objectDescription);
        }
    }
}

