/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.dsl.MultiFieldPredicateFieldBoostStep;

public class FieldContext {
    private final String field;
    private boolean ignoreAnalyzer;
    private float fieldBoost = 1.0f;
    private boolean ignoreFieldBridge;

    public FieldContext(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public boolean skipAnalysis() {
        return this.ignoreAnalyzer;
    }

    public void setIgnoreAnalyzer(boolean ignoreAnalyzer) {
        this.ignoreAnalyzer = ignoreAnalyzer;
    }

    public <S> S applyBoost(MultiFieldPredicateFieldBoostStep<S> step) {
        return (S)step.boost(this.fieldBoost);
    }

    public void boostedTo(float boost) {
        this.fieldBoost *= boost;
    }

    public ValueConvert getValueConvert() {
        return this.ignoreFieldBridge ? ValueConvert.NO : ValueConvert.YES;
    }

    public void setIgnoreFieldBridge(boolean ignoreFieldBridge) {
        this.ignoreFieldBridge = ignoreFieldBridge;
    }

    public String toString() {
        return "FieldContext [field=" + this.field + ", fieldBoost=" + this.fieldBoost + ", ignoreAnalyzer=" + this.ignoreAnalyzer + ", ignoreFieldBridge=" + this.ignoreFieldBridge + "]";
    }
}

