/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.BuildException;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.api.metadata.MetadataDescriptorFactory;
import org.hibernate.tool.api.reveng.RevengSettings;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.RevengStrategyFactory;

public abstract class AbstractGenerationMojo
extends AbstractMojo {
    @Parameter
    private String packageName;
    @Parameter
    private File revengFile;
    @Parameter
    private String revengStrategy;
    @Parameter(defaultValue="true")
    private boolean detectManyToMany;
    @Parameter(defaultValue="true")
    private boolean detectOneToOne;
    @Parameter(defaultValue="true")
    private boolean detectOptimisticLock;
    @Parameter(defaultValue="true")
    private boolean createCollectionForForeignKey;
    @Parameter(defaultValue="true")
    private boolean createManyToOneForForeignKey;
    @Parameter(defaultValue="${project.basedir}/src/main/hibernate/hibernate.properties")
    private File propertyFile;
    private boolean preferBasicCompositeIds = true;

    public void execute() {
        this.getLog().info((CharSequence)("Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "..."));
        RevengStrategy strategy = this.setupReverseEngineeringStrategy();
        Properties properties = this.loadPropertiesFile();
        MetadataDescriptor jdbcDescriptor = this.createJdbcDescriptor(strategy, properties);
        this.executeExporter(jdbcDescriptor);
        this.getLog().info((CharSequence)("Finished " + ((Object)((Object)this)).getClass().getSimpleName() + "!"));
    }

    private RevengStrategy setupReverseEngineeringStrategy() {
        File[] revengFiles = null;
        if (this.revengFile != null) {
            revengFiles = new File[]{this.revengFile};
        }
        RevengStrategy strategy = RevengStrategyFactory.createReverseEngineeringStrategy((String)this.revengStrategy, revengFiles);
        RevengSettings settings = new RevengSettings(strategy).setDefaultPackageName(this.packageName).setDetectManyToMany(this.detectManyToMany).setDetectOneToOne(this.detectOneToOne).setDetectOptimisticLock(this.detectOptimisticLock).setCreateCollectionForForeignKey(this.createCollectionForForeignKey).setCreateManyToOneForForeignKey(this.createManyToOneForForeignKey);
        strategy.setSettings(settings);
        return strategy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadPropertiesFile() {
        if (this.propertyFile == null) {
            return null;
        }
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(this.propertyFile);){
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException e) {
            throw new BuildException(this.propertyFile + " not found.", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Problem while loading " + this.propertyFile, (Throwable)e);
        }
    }

    private MetadataDescriptor createJdbcDescriptor(RevengStrategy strategy, Properties properties) {
        properties.put("org.hibernate.tool.api.metadata.MetadataConstants.PreferBasicCompositeIds", (Object)this.preferBasicCompositeIds);
        return MetadataDescriptorFactory.createReverseEngineeringDescriptor((RevengStrategy)strategy, (Properties)properties);
    }

    protected abstract void executeExporter(MetadataDescriptor var1);
}

