/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.JavolutionError;
import javolution.context.ObjectFactory;
import javolution.context.ObjectPool;
import javolution.context.PoolContext;
import javolution.context.Realtime;
import javolution.lang.Reflection;
import javolution.text.Text;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealtimeObject
implements Realtime {
    private transient Pool _pool;
    private transient RealtimeObject _next;
    private transient RealtimeObject _previous;
    private transient int _preserved;

    protected RealtimeObject() {
    }

    public final boolean isLocal() {
        if (this._pool == null) {
            return false;
        }
        if (!this._pool._isStack) {
            return false;
        }
        if (this._pool._user == Thread.currentThread()) {
            return true;
        }
        if (this._pool._user != null || !this._pool._inUse) {
            throw new JavolutionError("Non Accessible Object");
        }
        return false;
    }

    public final String toString() {
        return this.toText().stringValue();
    }

    @Override
    public Text toText() {
        return Text.valueOf(this.getClass().getName()).concat(Text.valueOf('@')).concat(Text.valueOf(System.identityHashCode(this), 16));
    }

    public final <T> T export() {
        this.move(Realtime.ObjectSpace.OUTER);
        return (T)this;
    }

    public final <T> T moveHeap() {
        this.move(Realtime.ObjectSpace.HEAP);
        return (T)this;
    }

    public final <T> T preserve() {
        this.move(Realtime.ObjectSpace.HOLD);
        return (T)this;
    }

    public final <T> T unpreserve() {
        this.move(Realtime.ObjectSpace.STACK);
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean move(Realtime.ObjectSpace objectSpace) {
        if (objectSpace == Realtime.ObjectSpace.OUTER) {
            if (!this.isLocal()) {
                return false;
            }
            Pool pool = (Pool)PoolContext.current().getOuter().getPool(((Pool)this._pool)._factory._index, false);
            if (!pool._isStack) {
                return this.move(Realtime.ObjectSpace.HEAP);
            }
            this.detach();
            Pool pool2 = pool;
            synchronized (pool2) {
                RealtimeObject realtimeObject = (RealtimeObject)pool.next();
                realtimeObject.detach();
                realtimeObject.insertBefore(this._pool._activeTail);
                realtimeObject._pool = this._pool;
                this.insertBefore(pool._next);
                this._pool = pool;
            }
            return true;
        }
        if (objectSpace == Realtime.ObjectSpace.HEAP) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._pool == null || !this._pool._isStack) {
                    return false;
                }
                Pool pool = this._pool;
                synchronized (pool) {
                    this.detach();
                    this._pool._size--;
                    this._pool = null;
                    this._next = null;
                    this._previous = null;
                    return true;
                }
            }
        }
        if (objectSpace == Realtime.ObjectSpace.HOLD) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._pool == null || !this._pool._isStack) {
                    return false;
                }
                if (this._preserved++ == 0) {
                    Pool pool = this._pool;
                    synchronized (pool) {
                        this.detach();
                        this.insertBefore(this._pool._holdTail);
                    }
                    return true;
                }
                return false;
            }
        }
        if (objectSpace == Realtime.ObjectSpace.STACK) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._preserved != 0 && --this._preserved == 0) {
                    if (this._pool != null) {
                        Pool pool = this._pool;
                        synchronized (pool) {
                            this.detach();
                            this.insertBefore(this._pool._next);
                            this._pool._next = this;
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    final void insertBefore(RealtimeObject realtimeObject) {
        this._previous = realtimeObject._previous;
        this._next = realtimeObject;
        this._next._previous = this;
        this._previous._next = this;
    }

    final void detach() {
        this._next._previous = this._previous;
        this._previous._next = this._next;
    }

    private static final class Bound
    extends RealtimeObject {
        private Bound() {
        }
    }

    private static final class Pool
    extends ObjectPool
    implements Runnable {
        static final XMLFormat XML = new XMLFormat((Class)new Pool(null, false).getClass()){

            public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
                Class clazz2;
                try {
                    clazz2 = Reflection.getClass(inputElement.getAttribute("factory"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new XMLStreamException(classNotFoundException);
                }
                Factory factory = (Factory)ObjectFactory.getInstance(clazz2);
                boolean bl = inputElement.getAttribute("isStack", false);
                return new Pool(factory, bl);
            }

            public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
                Pool pool = (Pool)object;
                ObjectPool.XML.read(inputElement, pool);
            }

            public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
                Pool pool = (Pool)object;
                outputElement.setAttribute("isStack", pool._isStack);
                ObjectPool.XML.write(pool, outputElement);
            }
        };
        private final Factory _factory;
        private final MemoryArea _memoryArea;
        private int _size;
        private final RealtimeObject _activeHead;
        private final RealtimeObject _activeTail;
        private final RealtimeObject _holdHead;
        private final RealtimeObject _holdTail;
        private RealtimeObject _next;
        private final boolean _isStack;

        private Pool(Factory factory, boolean bl) {
            this._factory = factory;
            this._isStack = bl;
            this._memoryArea = MemoryArea.getMemoryArea(this);
            this._activeHead = new Bound();
            this._activeTail = new Bound();
            this._activeHead._next = this._activeTail;
            this._activeTail._previous = this._activeHead;
            this._holdHead = new Bound();
            this._holdTail = new Bound();
            this._holdHead._next = this._holdTail;
            this._holdTail._previous = this._holdHead;
            this._next = this._activeTail;
        }

        public ObjectFactory getFactory() {
            return this._factory;
        }

        public int getSize() {
            return this._size;
        }

        public void setSize(int n) {
            for (int i = this._size; i < n; ++i) {
                RealtimeObject realtimeObject = (RealtimeObject)this._factory.create();
                ++this._size;
                if (this._isStack) {
                    realtimeObject.insertBefore(this._activeTail);
                    realtimeObject._pool = this;
                    continue;
                }
                realtimeObject.insertBefore(this._holdTail);
            }
        }

        public Object next() {
            RealtimeObject realtimeObject = this._next;
            this._next = realtimeObject._next;
            return this._next != null ? realtimeObject : this.allocate();
        }

        private Object allocate() {
            this._next = this._activeTail;
            if (this._isStack) {
                this._memoryArea.executeInArea(this);
                return this._activeTail._previous;
            }
            if (this._size != 0) {
                this.removeUse();
            }
            return this._factory.create();
        }

        private void removeUse() {
            RealtimeObject realtimeObject = this._activeHead._next;
            if (realtimeObject == this._activeTail) {
                throw new JavolutionError("Non empty pool with size zero");
            }
            realtimeObject.detach();
            realtimeObject._next = null;
            realtimeObject._previous = null;
            realtimeObject._pool = null;
            --this._size;
        }

        public void run() {
            RealtimeObject realtimeObject = (RealtimeObject)this._factory.create();
            ++this._size;
            realtimeObject.insertBefore(this._activeTail);
            realtimeObject._pool = this;
        }

        public void recycle(Object object) {
            RealtimeObject realtimeObject;
            Pool pool;
            if (this._factory.doCleanup()) {
                this._factory.cleanup(object);
            }
            if ((pool = (realtimeObject = (RealtimeObject)object)._pool) == this) {
                realtimeObject.detach();
                realtimeObject.insertBefore(this._next);
                this._next = this._next._previous;
                return;
            }
            if (pool == null) {
                if (MemoryArea.getMemoryArea(realtimeObject) != this._memoryArea) {
                    return;
                }
                realtimeObject.insertBefore(this._next);
                realtimeObject._pool = this;
                this._next = this._next._previous;
                ++this._size;
                return;
            }
            throw new IllegalArgumentException("Cannot recycle object belonging to a different context");
        }

        protected void recycleAll() {
            RealtimeObject realtimeObject = this._activeHead._next;
            while (realtimeObject != this._next && this._factory.doCleanup()) {
                this._factory.cleanup(realtimeObject);
                realtimeObject = realtimeObject._next;
            }
            this._next = this._activeHead._next;
        }

        protected void clearAll() {
            this._activeHead._next = this._activeTail;
            this._activeTail._previous = this._activeHead;
            this._holdHead._next = this._holdTail;
            this._holdTail._previous = this._holdHead;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Factory<T extends RealtimeObject>
    extends ObjectFactory<T> {
        private Pool _cachedPool = new Pool(null, false);

        protected Factory() {
        }

        @Override
        public final T object() {
            Pool pool = this._cachedPool;
            if (pool._user == Thread.currentThread()) {
                RealtimeObject realtimeObject = pool._next;
                return (T)((RealtimeObject)((pool._next = realtimeObject._next) != null ? realtimeObject : pool.allocate()));
            }
            this._cachedPool = pool = (Pool)this.currentPool();
            return (T)((RealtimeObject)pool.next());
        }

        @Override
        public void recycle(T t) {
            Pool pool = ((RealtimeObject)t)._pool;
            if (pool == null) {
                this.currentPool().recycle(t);
            } else {
                pool.recycle((Object)t);
            }
        }

        @Override
        protected ObjectPool newStackPool() {
            return new Pool(this, true);
        }

        @Override
        protected ObjectPool newHeapPool() {
            return new Pool(this, false);
        }
    }
}

