/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.Serializable;
import javax.realtime.MemoryArea;
import javolution.context.Realtime;
import javolution.context.RealtimeObject;
import javolution.lang.MathLib;
import javolution.lang.Reusable;
import javolution.text.Text;

public class TextBuilder
extends RealtimeObject
implements Appendable,
CharSequence,
Reusable,
Serializable {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new TextBuilder();
        }
    };
    private static final int D0 = 5;
    private static final int M0 = 31;
    private static final int C0 = 32;
    private static final int D1 = 7;
    private static final int R1 = 5;
    private static final int M1 = 127;
    private static final int C1 = 4096;
    private static final int D2 = 9;
    private static final int R2 = 12;
    private static final int M2 = 511;
    private static final int C2 = 0x200000;
    private static final int D3 = 11;
    private static final int R3 = 21;
    private final char[] _chars0 = new char[32];
    private char[][] _chars1;
    private char[][][] _chars2;
    private char[][][][] _chars3;
    private int _capacity = 32;
    private int _length;
    private static final long[] LONG_POW_10 = new long[19];
    private static final char[] DIGIT_TO_CHAR;

    public TextBuilder() {
    }

    public TextBuilder(CharSequence charSequence) {
        this.append(charSequence);
    }

    public TextBuilder(String string) {
        this.append(string);
    }

    public TextBuilder(int n) {
        while (n > this._capacity) {
            this.increaseCapacity();
        }
    }

    public static TextBuilder newInstance() {
        TextBuilder textBuilder = (TextBuilder)FACTORY.object();
        textBuilder._length = 0;
        return textBuilder;
    }

    public static void recycle(TextBuilder textBuilder) {
        FACTORY.recycle(textBuilder);
    }

    public final int length() {
        return this._length;
    }

    public final char charAt(int n) {
        return n < 32 && n < this._length ? this._chars0[n] : this.charAt2(n);
    }

    private final char charAt2(int n) {
        if (n >= this._length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return n < 4096 ? this._chars1[n >> 5][n & 0x1F] : (n < 0x200000 ? this._chars2[n >> 12][n >> 5 & 0x7F][n & 0x1F] : this._chars3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F]);
    }

    public final void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n3 < 0 || n > n2 || n2 > this.length() || n3 + n2 - n > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n;
        int n5 = n3;
        while (n4 < n2) {
            cArray[n5++] = this.charAt(n4++);
        }
    }

    public final void setCharAt(int n, char c) {
        if (n < 0 || n >= this._length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        if (n < 32) {
            this._chars0[n] = c;
        } else if (n < 4096) {
            this._chars1[n >> 5][n & 0x1F] = c;
        } else if (n < 0x200000) {
            this._chars2[n >> 12][n >> 5 & 0x7F][n & 0x1F] = c;
        } else {
            this._chars3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F] = c;
        }
    }

    public final void setLength(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= this._length) {
            this._length = n;
        } else {
            int n2 = this._length;
            while (n2++ < n) {
                this.append('\u0000');
            }
        }
    }

    public final CharSequence subSequence(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > this._length) {
            throw new IndexOutOfBoundsException();
        }
        return Text.valueOf(this, n, n2);
    }

    public final TextBuilder append(char c) {
        if (this._length >= 32) {
            return this.append2(c);
        }
        this._chars0[this._length++] = c;
        return this;
    }

    private TextBuilder append2(char c) {
        int n;
        if (this._length >= this._capacity) {
            this.increaseCapacity();
        }
        if ((n = this._length++) < 4096) {
            this._chars1[n >> 5][n & 0x1F] = c;
        } else if (n < 0x200000) {
            this._chars2[n >> 12][n >> 5 & 0x7F][n & 0x1F] = c;
        } else {
            this._chars3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F] = c;
        }
        return this;
    }

    public final TextBuilder append(CharSequence charSequence) {
        return charSequence == null ? this.append("null") : this.append(charSequence, 0, charSequence.length());
    }

    public final TextBuilder append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return this.append("null");
        }
        if (n < 0 || n2 < 0 || n > n2 || n2 > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n2) {
            this.append(charSequence.charAt(n3++));
        }
        return this;
    }

    public final TextBuilder append(Object object) {
        if (object instanceof String) {
            return this.append((String)object);
        }
        if (object instanceof CharSequence) {
            return this.append((CharSequence)object);
        }
        if (object instanceof Realtime) {
            return this.append(((Realtime)object).toText());
        }
        if (object != null) {
            return this.append(object.toString());
        }
        return this.append("null");
    }

    public final TextBuilder append(String string) {
        if (string == null) {
            return this.append("null");
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.append(string.charAt(n2++));
        }
        return this;
    }

    public final TextBuilder append(String string, int n, int n2) {
        if (string == null) {
            return this.append("null");
        }
        if (n < 0 || n2 < 0 || n > n2 || n2 > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n2) {
            this.append(string.charAt(n3++));
        }
        return this;
    }

    public TextBuilder append(Text text) {
        if (text == null) {
            return this.append("null");
        }
        int n = text.length();
        int n2 = 0;
        while (n2 < n) {
            this.append(text.charAt(n2++));
        }
        return this;
    }

    public final TextBuilder append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public final TextBuilder append(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.append(cArray[n4++]);
        }
        return this;
    }

    public final TextBuilder append(boolean bl) {
        return bl ? this.append("true") : this.append("false");
    }

    public final TextBuilder append(int n) {
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                return this.append("-2147483648");
            }
            n = -n;
            this.append('-');
        }
        if (n >= 100000) {
            int n2 = n / 100000;
            this.writeDigits(n2, false);
            this.writeDigits(n -= n2 * 100000, true);
        } else {
            this.writeDigits(n, false);
        }
        return this;
    }

    public final TextBuilder append(int n, int n2) {
        if (n2 == 10) {
            return this.append(n);
        }
        if (n2 < 2 || n2 > 36) {
            throw new IllegalArgumentException("radix: " + n2);
        }
        if (n < 0) {
            this.append('-');
        } else {
            n = -n;
        }
        this.append2(n, n2);
        return this;
    }

    private void append2(int n, int n2) {
        if (n <= -n2) {
            this.append2(n / n2, n2);
            this.append(DIGIT_TO_CHAR[-(n % n2)]);
        } else {
            this.append(DIGIT_TO_CHAR[-n]);
        }
    }

    public final TextBuilder append(long l) {
        int n;
        if (l < 0L) {
            if (l == Long.MIN_VALUE) {
                return this.append("-9223372036854775808");
            }
            l = -l;
            this.append('-');
        }
        boolean bl = false;
        if (l >= 1000000000000000L) {
            n = (int)(l / 1000000000000000L);
            this.writeDigits(n, bl);
            l -= (long)n * 1000000000000000L;
            bl = true;
        }
        if (bl || l >= 10000000000L) {
            n = (int)(l / 10000000000L);
            this.writeDigits(n, bl);
            l -= (long)n * 10000000000L;
            bl = true;
        }
        if (bl || l >= 100000L) {
            n = (int)(l / 100000L);
            this.writeDigits(n, bl);
            l -= (long)n * 100000L;
            bl = true;
        }
        this.writeDigits((int)l, bl);
        return this;
    }

    public final TextBuilder append(long l, int n) {
        if (n == 10) {
            return this.append(l);
        }
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("radix: " + n);
        }
        if (l < 0L) {
            this.append('-');
        } else {
            l = -l;
        }
        this.append2(l, n);
        return this;
    }

    private void append2(long l, int n) {
        if (l <= (long)(-n)) {
            this.append2(l / (long)n, n);
            this.append(DIGIT_TO_CHAR[(int)(-(l % (long)n))]);
        } else {
            this.append(DIGIT_TO_CHAR[(int)(-l)]);
        }
    }

    public final TextBuilder append(float f) {
        return this.append(f, 10, (double)MathLib.abs(f) >= 1.0E7 || (double)MathLib.abs(f) < 0.001, false);
    }

    public final TextBuilder append(double d) {
        return this.append(d, 17, MathLib.abs(d) >= 1.0E7 || MathLib.abs(d) < 0.001, false);
    }

    public final TextBuilder append(double d, int n, boolean bl, boolean bl2) {
        if (n > 19 || n <= 0) {
            throw new IllegalArgumentException("digits: " + n);
        }
        if (d != d) {
            return this.append("NaN");
        }
        if (d < 0.0) {
            d = -d;
            this.append('-');
        }
        if (d == Double.POSITIVE_INFINITY) {
            return this.append("Infinity");
        }
        if (d == 0.0) {
            if (n == 1) {
                return this.append("0.");
            }
            if (!bl2) {
                return this.append("0.0");
            }
            this.append("0.0");
            for (int i = 2; i < n; ++i) {
                this.append('0');
            }
            return this;
        }
        int n2 = MathLib.floorLog10(d);
        long l = MathLib.toLongPow10(d, n - n2 - 1);
        if (bl || n2 >= n) {
            long l2 = LONG_POW_10[n - 1];
            int n3 = (int)(l / l2);
            this.append(DIGIT_TO_CHAR[n3]);
            long l3 = l - l2 * (long)n3;
            this.appendFraction(l3, n - 1, bl2);
            this.append('E');
            this.append(n2);
        } else if (n2 < 0) {
            this.append('0');
            this.appendFraction(l, n - n2 - 1, bl2);
        } else {
            long l4 = LONG_POW_10[n - n2 - 1];
            long l5 = l / l4;
            this.append(l5);
            long l6 = l - l4 * l5;
            this.appendFraction(l6, n - n2 - 1, bl2);
        }
        return this;
    }

    final void appendFraction(long l, int n, boolean bl) {
        int n2;
        this.append('.');
        int n3 = MathLib.digitLength(l);
        if (n3 == 0 && !bl) {
            this.append('0');
            return;
        }
        for (n2 = n3; n2 < n; ++n2) {
            this.append('0');
        }
        this.append(l);
        if (!bl) {
            char c;
            n2 = 0;
            while ((c = this.charAt(this._length - n2 - 1)) == '0') {
                ++n2;
            }
            this.setLength(this._length - n2);
        }
    }

    public final TextBuilder insert(int n, CharSequence charSequence) {
        if (n < 0 || n > this._length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = charSequence.length();
        this._length += n2;
        while (this._length >= this._capacity) {
            this.increaseCapacity();
        }
        int n3 = this._length - n2;
        while (--n3 >= n) {
            this.setCharAt(n3 + n2, this.charAt(n3));
        }
        n3 = charSequence.length();
        while (--n3 >= 0) {
            this.setCharAt(n + n3, charSequence.charAt(n3));
        }
        return this;
    }

    public final TextBuilder clear() {
        this._length = 0;
        return this;
    }

    public final TextBuilder delete(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2;
        int n4 = n;
        while (n3 < this._length) {
            this.setCharAt(n4++, this.charAt(n3++));
        }
        this._length -= n2 - n;
        return this;
    }

    public final TextBuilder reverse() {
        int n = this._length - 1;
        int n2 = n - 1 >> 1;
        while (n2 >= 0) {
            char c = this.charAt(n2);
            this.setCharAt(n2, this.charAt(n - n2));
            this.setCharAt(n - n2--, c);
        }
        return this;
    }

    public final Text toText() {
        return Text.valueOf(this, 0, this.length());
    }

    public final void reset() {
        this._length = 0;
    }

    public final int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._length) {
            n = 31 * n + this.charAt(n2++);
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextBuilder)) {
            return false;
        }
        TextBuilder textBuilder = (TextBuilder)object;
        if (this._length != textBuilder._length) {
            return false;
        }
        int n = 0;
        while (n < this._length) {
            if (this.charAt(n) == textBuilder.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    final void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this._chars0, 0, this._length);
    }

    final void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(this._chars0, 0, this._length);
    }

    public final boolean contentEquals(CharSequence charSequence) {
        if (charSequence.length() != this._length) {
            return false;
        }
        int n = 0;
        while (n < this._length) {
            if (this.charAt(n) == charSequence.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int n = TextBuilder.this._capacity;
                TextBuilder.this._capacity += 32;
                if (n < 4096) {
                    if (TextBuilder.this._chars1 == null) {
                        TextBuilder.access$102(TextBuilder.this, new char[128][]);
                    }
                    ((TextBuilder)TextBuilder.this)._chars1[n >> 5] = new char[32];
                } else if (n < 0x200000) {
                    if (TextBuilder.this._chars2 == null) {
                        TextBuilder.access$202(TextBuilder.this, new char[512][][]);
                    }
                    if (TextBuilder.this._chars2[n >> 12] == null) {
                        ((TextBuilder)TextBuilder.this)._chars2[n >> 12] = new char[128][];
                    }
                    ((TextBuilder)TextBuilder.this)._chars2[n >> 12][n >> 5 & 0x7F] = new char[32];
                } else {
                    if (TextBuilder.this._chars3 == null) {
                        TextBuilder.access$302(TextBuilder.this, new char[2048][][][]);
                    }
                    if (TextBuilder.this._chars3[n >> 21] == null) {
                        ((TextBuilder)TextBuilder.this)._chars3[n >> 21] = new char[512][][];
                    }
                    if (TextBuilder.this._chars3[n >> 21][n >> 12 & 0x1FF] == null) {
                        ((TextBuilder)TextBuilder.this)._chars3[n >> 21][n >> 12 & 0x1FF] = new char[128][];
                    }
                    ((TextBuilder)TextBuilder.this)._chars3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F] = new char[32];
                }
            }
        });
    }

    private void writeDigits(int n, boolean bl) {
        if (n >= 10000) {
            bl = true;
            if (n >= 50000) {
                if (n >= 80000) {
                    if (n >= 90000) {
                        this.append('9');
                        n -= 90000;
                    } else {
                        this.append('8');
                        n -= 80000;
                    }
                } else if (n >= 70000) {
                    this.append('7');
                    n -= 70000;
                } else if (n >= 60000) {
                    this.append('6');
                    n -= 60000;
                } else {
                    this.append('5');
                    n -= 50000;
                }
            } else if (n >= 30000) {
                if (n >= 40000) {
                    this.append('4');
                    n -= 40000;
                } else {
                    this.append('3');
                    n -= 30000;
                }
            } else if (n >= 20000) {
                this.append('2');
                n -= 20000;
            } else {
                this.append('1');
                n -= 10000;
            }
        } else if (bl) {
            this.append('0');
        }
        if (n >= 1000) {
            bl = true;
            if (n >= 5000) {
                if (n >= 8000) {
                    if (n >= 9000) {
                        this.append('9');
                        n -= 9000;
                    } else {
                        this.append('8');
                        n -= 8000;
                    }
                } else if (n >= 7000) {
                    this.append('7');
                    n -= 7000;
                } else if (n >= 6000) {
                    this.append('6');
                    n -= 6000;
                } else {
                    this.append('5');
                    n -= 5000;
                }
            } else if (n >= 3000) {
                if (n >= 4000) {
                    this.append('4');
                    n -= 4000;
                } else {
                    this.append('3');
                    n -= 3000;
                }
            } else if (n >= 2000) {
                this.append('2');
                n -= 2000;
            } else {
                this.append('1');
                n -= 1000;
            }
        } else if (bl) {
            this.append('0');
        }
        if (n >= 100) {
            bl = true;
            if (n >= 500) {
                if (n >= 800) {
                    if (n >= 900) {
                        this.append('9');
                        n -= 900;
                    } else {
                        this.append('8');
                        n -= 800;
                    }
                } else if (n >= 700) {
                    this.append('7');
                    n -= 700;
                } else if (n >= 600) {
                    this.append('6');
                    n -= 600;
                } else {
                    this.append('5');
                    n -= 500;
                }
            } else if (n >= 300) {
                if (n >= 400) {
                    this.append('4');
                    n -= 400;
                } else {
                    this.append('3');
                    n -= 300;
                }
            } else if (n >= 200) {
                this.append('2');
                n -= 200;
            } else {
                this.append('1');
                n -= 100;
            }
        } else if (bl) {
            this.append('0');
        }
        if (n >= 10) {
            bl = true;
            if (n >= 50) {
                if (n >= 80) {
                    if (n >= 90) {
                        this.append('9');
                        n -= 90;
                    } else {
                        this.append('8');
                        n -= 80;
                    }
                } else if (n >= 70) {
                    this.append('7');
                    n -= 70;
                } else if (n >= 60) {
                    this.append('6');
                    n -= 60;
                } else {
                    this.append('5');
                    n -= 50;
                }
            } else if (n >= 30) {
                if (n >= 40) {
                    this.append('4');
                    n -= 40;
                } else {
                    this.append('3');
                    n -= 30;
                }
            } else if (n >= 20) {
                this.append('2');
                n -= 20;
            } else {
                this.append('1');
                n -= 10;
            }
        } else if (bl) {
            this.append('0');
        }
        this.append(DIGIT_TO_CHAR[n]);
    }

    static /* synthetic */ char[][] access$102(TextBuilder textBuilder, char[][] cArray) {
        textBuilder._chars1 = cArray;
        return cArray;
    }

    static /* synthetic */ char[][][] access$202(TextBuilder textBuilder, char[][][] cArray) {
        textBuilder._chars2 = cArray;
        return cArray;
    }

    static /* synthetic */ char[][][][] access$302(TextBuilder textBuilder, char[][][][] cArray) {
        textBuilder._chars3 = cArray;
        return cArray;
    }

    static {
        long l = 1L;
        for (int i = 0; i < 19; ++i) {
            TextBuilder.LONG_POW_10[i] = l;
            l *= 10L;
        }
        DIGIT_TO_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    }
}

