/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.page;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.jboss.aesh.extensions.page.PageLoader;

public class SimplePageLoader
implements PageLoader {
    private String pageAsString;
    private String fileName;
    private InputStreamReader reader;

    public void setFile(String filename) throws IOException {
        this.setFile(new File(filename));
    }

    public void setFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " must be a file.");
        }
        if (file.getName().endsWith("gz")) {
            this.initGzReader(file);
        } else {
            this.initReader(file);
        }
    }

    public void setFileFromAJar(String fileName) {
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is != null) {
            this.fileName = fileName;
            this.reader = new InputStreamReader(is);
        }
    }

    private void initReader(File file) throws FileNotFoundException {
        this.fileName = file.getAbsolutePath();
        this.reader = new FileReader(file);
    }

    public void readPageAsString(String pageAsString) {
        this.pageAsString = pageAsString;
    }

    @Override
    public String getResourceName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return "STREAM";
    }

    private void initGzReader(File file) throws IOException {
        this.fileName = file.getAbsolutePath();
        GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(file));
        this.reader = new InputStreamReader(gzip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> loadPage(int columns) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.reader != null) {
            BufferedReader br = new BufferedReader(this.reader);
            try {
                String line = br.readLine();
                while (line != null) {
                    if (line.length() > columns) {
                        for (String s : line.split("(?<=\\G.{" + columns + "})")) {
                            lines.add(s);
                        }
                    } else {
                        lines.add(line);
                    }
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
        } else if (this.pageAsString != null) {
            for (String s : this.pageAsString.split("\n")) {
                for (String s2 : s.split("(?<=\\G.{" + columns + "})")) {
                    lines.add(s2);
                }
            }
        }
        return lines;
    }
}

