/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.choice;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCommand;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.extensions.choice.MultipleChoice;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.LoggerUtil;

public class MultipleChoiceCommand
implements ConsoleCommand,
Completion {
    private List<MultipleChoice> choices;
    private String commandName;
    private int rows;
    private Console console;
    private boolean attached = true;
    private Logger logger = LoggerUtil.getLogger((String)MultipleChoiceCommand.class.getName());

    public MultipleChoiceCommand(Console console) {
        this.console = console;
    }

    public MultipleChoiceCommand(Console console, String commandName, List<MultipleChoice> choices) {
        this.console = console;
        this.commandName = commandName;
        this.choices = choices;
    }

    public List<MultipleChoice> getChoices() {
        return this.choices;
    }

    public void complete(CompleteOperation completeOperation) {
    }

    public boolean isAttached() {
        return this.attached;
    }

    protected void afterAttach() throws IOException {
        this.rows = this.console.getTerminalSize().getHeight();
        this.console.out().write(ANSI.getAlternateBufferScreen());
        this.logger.info("printed out alternateBufferScreen");
        this.displayChoices();
    }

    private void displayChoices() throws IOException {
        this.console.clear();
        for (int i = 0; i < this.rows - this.choices.size() - 1; ++i) {
            this.console.out().print(Config.getLineSeparator());
        }
        for (MultipleChoice mc : this.choices) {
            if (mc.isChosen()) {
                this.console.out().print(mc.getId() + ") " + mc.getDisplayString() + " [X]" + Config.getLineSeparator());
                continue;
            }
            this.console.out().print(mc.getId() + ") " + mc.getDisplayString() + " [ ]" + Config.getLineSeparator());
        }
        this.console.out().print("Choose options: 1-" + this.choices.size() + ": ");
        this.console.out().flush();
    }

    protected void afterDetach() throws IOException {
        this.console.out().print(ANSI.getMainBufferScreen());
        this.attached = false;
    }

    public void processOperation(Operation operation) throws IOException {
        if (Character.isDigit(operation.getInput()[0])) {
            int c = Character.getNumericValue(operation.getInput()[0]);
            this.console.out().print("got " + c + "\n");
            this.updateChoices(c);
            this.displayChoices();
        } else if (operation.getInput()[0] == 113) {
            this.afterDetach();
        }
    }

    private void updateChoices(int id) {
        for (MultipleChoice c : this.choices) {
            if (c.getId() != id) continue;
            c.selectChoise();
        }
    }
}

