/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.Command;
import org.jboss.aesh.console.CommandResult;
import org.jboss.aesh.console.MutableCommandRegistry;
import org.jboss.aesh.console.operator.ControlOperator;

@CommandDefinition(name="add-command", description="specify a groovy command file ")
public class GroovyCommand
implements Command {
    private AeshConsole aeshConsole;
    @Arguments
    private List<File> files;

    public CommandResult execute(AeshConsole aeshConsole, ControlOperator operator) throws IOException {
        this.aeshConsole = aeshConsole;
        if (this.files != null && this.files.size() > 0) {
            this.loadCommand(this.files.get(0));
        }
        return CommandResult.SUCCESS;
    }

    private void loadCommand(File file) {
        try {
            ClassLoader parent = this.getClass().getClassLoader();
            GroovyClassLoader loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(file);
            if (groovyClass.isAnnotationPresent(CommandDefinition.class)) {
                boolean correctClass = false;
                for (Class<?> groovyInterface : groovyClass.getInterfaces()) {
                    if (!groovyInterface.equals(Command.class)) continue;
                    correctClass = true;
                }
                if (correctClass) {
                    if (this.aeshConsole.getCommandRegistry() instanceof MutableCommandRegistry) {
                        ((MutableCommandRegistry)this.aeshConsole.getCommandRegistry()).addCommand(groovyClass);
                        this.aeshConsole.out().println("Added " + groovyClass.getName() + " to commands");
                    }
                } else {
                    this.aeshConsole.out().println("Groovy command do not implement Command interface");
                }
            } else {
                this.aeshConsole.out().println("Groovy command do not contain CommandDefinition annotation");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

