/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.manual;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.completer.CompleterData;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.cl.converter.CLConverter;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.CommandContainer;
import org.jboss.aesh.console.CommandNotFoundException;
import org.jboss.aesh.console.CommandRegistry;
import org.jboss.aesh.console.CommandResult;
import org.jboss.aesh.console.ConsoleCommand;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.extensions.manual.ManCommand;
import org.jboss.aesh.extensions.manual.ManPage;
import org.jboss.aesh.extensions.manual.parser.ManPageLoader;
import org.jboss.aesh.extensions.page.AeshFileDisplayer;
import org.jboss.aesh.extensions.page.PageLoader;
import org.jboss.aesh.util.ANSI;

@CommandDefinition(name="man", description="manuals")
public class AeshMan
extends AeshFileDisplayer {
    @Arguments(converter=ManConverter.class, completer=ManCompleter.class)
    private List<ManPage> manPages = new ArrayList<ManPage>();
    private ManPageLoader loader = new ManPageLoader();
    private static CommandRegistry registry;

    public void setRegistry(CommandRegistry registry) {
        AeshMan.registry = registry;
    }

    private void setFile(String name) throws IOException {
        this.loader.setFile(name);
    }

    private void setFile(URL url) throws IOException {
        this.loader.setUrlFile(url);
    }

    private void setFile(InputStream input, String fileName) throws IOException {
        this.loader.setFile(input, fileName);
    }

    @Override
    public PageLoader getPageLoader() {
        return this.loader;
    }

    @Override
    public void displayBottom() throws IOException {
        this.writeToConsole(ANSI.getInvertedBackground());
        this.writeToConsole("Manual page " + this.loader.getName() + " line " + this.getTopVisibleRow() + " (press h for help or q to quit)" + ANSI.defaultText());
    }

    public CommandResult execute(AeshConsole aeshConsole, ControlOperator operator) throws IOException {
        this.setConsole(aeshConsole);
        this.setControlOperator(operator);
        if (this.manPages != null && this.manPages.size() > 0) {
            try {
                CommandContainer manCommand = registry.getCommand(this.manPages.get(0).getCommand(), null);
                if (manCommand.getCommand() instanceof ManCommand) {
                    this.setFile(((ManCommand)manCommand.getCommand()).getManLocation().toString());
                    this.getConsole().attachConsoleCommand((ConsoleCommand)this);
                    this.afterAttach();
                }
            }
            catch (CommandNotFoundException e) {
                e.printStackTrace();
            }
        }
        return CommandResult.SUCCESS;
    }

    public static class ManConverter
    implements CLConverter<ManPage> {
        public ManPage convert(String location) {
            return new ManPage(location);
        }
    }

    public static class ManCompleter
    implements OptionCompleter {
        public void complete(CompleterData completerData) {
            ArrayList<String> completeValues = new ArrayList<String>();
            if (registry != null) {
                for (String command : registry.getAllCommandNames()) {
                    if (!command.startsWith(completerData.getGivenCompleteValue())) continue;
                    completeValues.add(command);
                }
                completerData.setCompleterValues(completeValues);
            }
        }
    }
}

