/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.page;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.extensions.page.PageLoader;

public abstract class Page {
    private List<String> lines;
    private PageLoader loader;

    public Page(PageLoader loader, int columns) {
        this.loader = loader;
        try {
            this.lines = loader.loadPage(columns);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getLine(int num) {
        if (num < this.lines.size()) {
            return this.lines.get(num);
        }
        return "";
    }

    public List<Integer> findWord(String word) {
        ArrayList<Integer> wordLines = new ArrayList<Integer>();
        for (int i = 0; i < this.lines.size(); ++i) {
            if (!this.lines.get(i).contains(word)) continue;
            wordLines.add(i);
        }
        return wordLines;
    }

    public int size() {
        return this.lines.size();
    }

    public String getFileName() {
        return this.loader.getResourceName();
    }

    public List<String> getLines() {
        return this.lines;
    }

    public boolean hasData() {
        return !this.lines.isEmpty();
    }

    public void clear() {
        this.lines.clear();
    }

    public static enum Search {
        SEARCHING,
        RESULT,
        NOT_FOUND,
        NO_SEARCH;

    }
}

