/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.scanner;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.extensions.text.highlight.Encoder;
import org.jboss.aesh.extensions.text.highlight.Scanner;
import org.jboss.aesh.extensions.text.highlight.Syntax;
import org.jboss.aesh.extensions.text.highlight.encoder.AssertEncoder;
import org.junit.Assert;

public abstract class AbstractScannerTestCase {
    public static final String ASSERT_ENCODER = "TEST";
    public static String OUTPUT = "target/examples";
    public static String BASE_URL = "https://raw.github.com/rubychan/coderay-scanner-tests/master/";
    public static Pattern MATCH_DATA = Pattern.compile("(.*)\\..*\\..*");

    public AbstractScannerTestCase() {
        Syntax.builtIns();
        Encoder.Factory.registrer((String)ASSERT_ENCODER, AssertEncoder.class);
    }

    protected String fetch(String type, String example) throws Exception {
        Path sourcePath = Paths.get(OUTPUT, type, example);
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            sourcePath.getParent().toFile().mkdirs();
            URL source = new URL(BASE_URL + type + "/" + example);
            System.out.println("Fetching " + source);
            Files.write(sourcePath, AbstractScannerTestCase.asByteArray(new BufferedInputStream(source.openStream())), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        return new String(Files.readAllBytes(sourcePath));
    }

    private String expectedName(String example) {
        Matcher result = MATCH_DATA.matcher(example);
        result.find();
        return result.group(1) + ".expected.raydebug";
    }

    protected void assertMatchExample(Syntax.Builder builder, String type, String exampleName) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String exampleContent = this.fetch(type, exampleName);
        String expectedContent = this.fetch(type, this.expectedName(exampleName));
        builder.output((OutputStream)out);
        builder.encoderType(ASSERT_ENCODER);
        builder.scanner(Scanner.Factory.byFileName((String)exampleName));
        builder.execute(exampleContent);
        out.flush();
        String result = new String(out.toByteArray());
        String[] resultLines = result.split("\n");
        String[] expectedLines = expectedContent.split("\n");
        for (int i = 0; i < resultLines.length; ++i) {
            String s = resultLines[i];
            String t = expectedLines[i];
            if (s.equals(t)) continue;
            System.out.println("--------------------------->" + (i + 1));
            System.out.println(exampleContent.split("\n")[i]);
            System.out.println("---------------------------");
            System.out.println("> " + s);
            System.out.println("< " + t);
            System.out.println("---------------------------");
            Assert.assertEquals((String)("verify line: " + (i + 1)), (Object)t, (Object)s);
        }
        Assert.assertEquals((Object)expectedContent, (Object)result);
    }

    static byte[] asByteArray(InputStream in) throws IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("stream must be specified");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        int len = 4096;
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in obtainting bytes from " + in, ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
        byte[] content = out.toByteArray();
        return content;
    }
}

