/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.cat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.util.PathResolver;

@CommandDefinition(name="cat", description="concatenate files and print on the standard output")
public class Cat
implements Command<CommandInvocation> {
    @Option(shortName=65, name="show-all", hasValue=false, description="equivalent to -vET")
    private boolean showAll;
    @Option(shortName=98, name="number-nonblank", hasValue=false, description="number nonempty output lines, overrides -n")
    private boolean numberNonBlank;
    @Option(shortName=69, name="show-ends", hasValue=false, description="display $ at end of each line")
    private boolean showEnds;
    @Option(shortName=110, name="number", hasValue=false, description="number all output lines")
    private boolean number;
    @Option(shortName=115, name="squeeze-blank", hasValue=false, description="suppress repeated empty output lines")
    private boolean squeezeBlank;
    @Option(shortName=84, name="show-tabs", hasValue=false, description="display TAB characters as ^I")
    private boolean showTabs;
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Arguments
    private List<File> files;
    private boolean prevBlank = false;
    private boolean currentBlank = false;
    private int counter;

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        if (this.help) {
            commandInvocation.getShell().out().print(commandInvocation.getHelpInfo("cat"));
            return CommandResult.SUCCESS;
        }
        try {
            this.counter = 1;
            if (this.showAll) {
                this.showEnds = true;
                this.showTabs = true;
            }
            if (commandInvocation.getShell().in().getStdIn().available() > 0) {
                Scanner s = new Scanner(commandInvocation.getShell().in().getStdIn()).useDelimiter("\\A");
                String input = s.hasNext() ? s.next() : "";
                commandInvocation.getShell().out().println();
                for (String i : input.split(Config.getLineSeparator())) {
                    this.displayLine(i, commandInvocation.getShell());
                }
                return CommandResult.SUCCESS;
            }
            if (this.files != null && this.files.size() > 0) {
                for (File f : this.files) {
                    this.displayFile((File)PathResolver.resolvePath((File)f, (File)commandInvocation.getAeshContext().getCurrentWorkingDirectory()).get(0), commandInvocation.getShell());
                }
                return CommandResult.SUCCESS;
            }
            this.readFromStdin(commandInvocation);
            return CommandResult.SUCCESS;
        }
        catch (FileNotFoundException fnfe) {
            commandInvocation.getShell().err().println("cat: " + fnfe.getMessage());
            return CommandResult.FAILURE;
        }
    }

    private void displayFile(File f, Shell shell) throws FileNotFoundException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    if (this.currentBlank && this.squeezeBlank) {
                        this.prevBlank = true;
                    }
                    this.currentBlank = true;
                } else {
                    this.currentBlank = false;
                    this.prevBlank = false;
                }
                this.displayLine(line, shell);
                line = br.readLine();
            }
            shell.out().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void displayLine(String line, Shell shell) {
        if (this.numberNonBlank) {
            if (!this.currentBlank) {
                shell.out().print(Parser.padLeft((int)6, (String)String.valueOf(this.counter)));
                shell.out().print(' ');
                ++this.counter;
            }
        } else if (this.number && !this.prevBlank) {
            shell.out().print(Parser.padLeft((int)6, (String)String.valueOf(this.counter)));
            shell.out().print(' ');
            ++this.counter;
        }
        if (this.showTabs) {
            if (line.contains("\t")) {
                line = line.replaceAll("\t", "^I");
            }
            if (!this.prevBlank) {
                shell.out().print(line);
            }
        } else if (!this.prevBlank) {
            shell.out().print(line);
        }
        if (this.showEnds && !this.prevBlank) {
            shell.out().print('$');
        }
        if (!this.prevBlank) {
            shell.out().print(Config.getLineSeparator());
        }
    }

    private void readFromStdin(CommandInvocation commandInvocation) {
        try {
            CommandOperation input = commandInvocation.getInput();
            StringBuilder builder = new StringBuilder();
            while (input.getInputKey() != Key.CTRL_C) {
                if (input.getInputKey() == Key.ENTER) {
                    commandInvocation.getShell().out().println();
                    this.displayLine(builder.toString(), commandInvocation.getShell());
                    builder = new StringBuilder();
                } else {
                    builder.append(input.getInputKey().getAsChar());
                    commandInvocation.getShell().out().print(input.getInputKey().getAsChar());
                }
                input = commandInvocation.getInput();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

