/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.pushdpopd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.util.PathResolver;

@CommandDefinition(name="pushd", description="usage: pushd [dir]")
public class Pushd
implements Command<CommandInvocation> {
    @Option(shortName=104, hasValue=false)
    private boolean help;
    @Arguments
    private List<File> arguments;
    private List<File> directories = new ArrayList<File>();

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
        if (this.help) {
            commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("pushd"));
            return CommandResult.SUCCESS;
        }
        if (this.arguments != null && this.arguments.size() > 0) {
            List files = PathResolver.resolvePath((File)this.arguments.get(0), (File)commandInvocation.getAeshContext().getCurrentWorkingDirectory());
            if (((File)files.get(0)).isDirectory()) {
                File oldCwd = commandInvocation.getAeshContext().getCurrentWorkingDirectory();
                this.directories.add(oldCwd);
                commandInvocation.getAeshContext().setCurrentWorkingDirectory((File)files.get(0));
                commandInvocation.getShell().out().println(files.get(0) + " " + this.getDirectoriesAsString());
                return CommandResult.SUCCESS;
            }
            return CommandResult.FAILURE;
        }
        commandInvocation.getShell().out().println("pushd: no other directory");
        return CommandResult.FAILURE;
    }

    private String getDirectoriesAsString() {
        StringBuilder builder = new StringBuilder();
        for (File f : this.directories) {
            if (builder.length() > 0) {
                builder.insert(0, " ");
            }
            builder.insert(0, f.toString());
        }
        return builder.toString();
    }

    public File popDirectory() {
        if (this.directories.size() > 0) {
            return this.directories.remove(this.directories.size() - 1);
        }
        return null;
    }
}

