/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.console;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.extensions.console.TestConsoleCallback;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TestTerminal;
import org.junit.Assert;

public abstract class BaseConsoleTest {
    public Settings getDefaultSettings(InputStream is, SettingsBuilder builder) {
        if (builder == null) {
            builder = new SettingsBuilder();
            builder.enableAlias(false);
        }
        builder.readInputrc(false);
        builder.terminal((Terminal)new TestTerminal());
        builder.inputStream(is);
        builder.outputStream(new PrintStream(new ByteArrayOutputStream()));
        builder.readAhead(true);
        if (!Config.isOSPOSIXCompatible()) {
            builder.ansi(false);
        }
        builder.create().getOperationManager().addOperation(new KeyOperation(Key.ENTER, Operation.NEW_LINE));
        return builder.create();
    }

    public Console getTestConsole(SettingsBuilder builder, InputStream is) throws IOException {
        return new Console(this.getDefaultSettings(is, builder));
    }

    public Console getTestConsole(InputStream is) throws IOException {
        return new Console(this.getDefaultSettings(is, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentOfFile(String filename) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(Config.getLineSeparator());
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }

    public void invokeTestConsole(Setup setup, Verify verify) throws Exception {
        this.invokeTestConsole(1, setup, verify);
    }

    public void invokeTestConsole(int callbackCount, Setup setup, Verify verify) throws Exception {
        this.invokeTestConsole(callbackCount, setup, verify, null);
    }

    public void invokeTestConsole(int callbackCount, Setup setup, final Verify verify, SettingsBuilder settings) throws Exception {
        PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(outputStream);
        CountDownLatch latch = new CountDownLatch(callbackCount);
        ArrayList exceptions = new ArrayList();
        Console consoleSetup = null;
        consoleSetup = settings != null ? this.getTestConsole(settings, pipedInputStream) : this.getTestConsole(pipedInputStream);
        final Console console = consoleSetup;
        console.setConsoleCallback((ConsoleCallback)new TestConsoleCallback(latch, exceptions){

            @Override
            public int verify(ConsoleOperation op) {
                try {
                    return verify.call(console, op);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        console.start();
        setup.call(console, outputStream);
        if (!latch.await(500L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Failed waiting for Console to finish");
        }
        console.stop();
        if (exceptions.size() > 0) {
            throw new RuntimeException((Throwable)exceptions.get(0));
        }
    }

    public static interface Verify {
        public int call(Console var1, ConsoleOperation var2) throws Exception;
    }

    public static interface Setup {
        public void call(Console var1, OutputStream var2) throws Exception;
    }
}

