/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.AeshConsoleBuilder;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.registry.AeshCommandRegistryBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TestTerminal;

public class AeshTestCommons {
    private PipedOutputStream pos = new PipedOutputStream();
    private PipedInputStream pis;
    private ByteArrayOutputStream stream;
    private Settings settings;
    private AeshConsole aeshConsole;
    private CommandRegistry registry;

    public AeshTestCommons() {
        try {
            this.pis = new PipedInputStream(this.pos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.stream = new ByteArrayOutputStream();
        this.settings = new SettingsBuilder().terminal((Terminal)new TestTerminal()).inputStream((InputStream)this.pis).outputStream(new PrintStream(this.stream)).logging(true).create();
    }

    protected void prepare(Class<? extends Command> ... commands) throws IOException {
        this.registry = new AeshCommandRegistryBuilder().commands((Class[])commands).create();
        AeshConsoleBuilder consoleBuilder = new AeshConsoleBuilder().settings(this.settings).commandRegistry(this.registry);
        this.aeshConsole = consoleBuilder.create();
        this.aeshConsole.start();
        this.getStream().flush();
    }

    protected void finish() {
        this.smallPause();
        System.out.println("Got out: " + this.getStream().toString());
        this.aeshConsole.stop();
    }

    protected PipedOutputStream getPipedOutputStream() {
        return this.pos;
    }

    protected ByteArrayOutputStream getStream() {
        return this.stream;
    }

    protected void smallPause() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void pushToOutput(String literalCommand) throws IOException {
        this.getPipedOutputStream().write(literalCommand.getBytes());
        this.getPipedOutputStream().write(Config.getLineSeparator().getBytes());
        this.getPipedOutputStream().flush();
        this.smallPause();
    }

    protected void output(String literalCommand) throws IOException {
        this.getPipedOutputStream().write(literalCommand.getBytes());
        this.smallPause();
    }
}

