/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.scanner;

import org.jboss.aesh.extensions.text.highlight.Syntax;
import org.jboss.aesh.extensions.text.highlight.TokenType;
import org.jboss.aesh.extensions.text.highlight.encoder.AssertEncoder;
import org.jboss.aesh.extensions.text.highlight.scanner.AbstractScannerTestCase;
import org.jboss.aesh.extensions.text.highlight.scanner.JSONScanner;
import org.junit.Ignore;
import org.junit.Test;

public class JSONScannerTestCase
extends AbstractScannerTestCase {
    @Test
    @Ignore
    public void should() throws Exception {
        String source = "[\n   {\n      \"precision\": \"zip\",\n      \"Latitude\":  37,\n      \"Longitude\": -122.3959,\n      \"Address\":   \"\",\n      \"City\":      \"SAN FRANCISCO\",\n      \"State\":     \"CA\",\n      \"Zip\":       \"94107\",\n      \"Country\":   \"US\"\n   },\n   {\n      \"precision\": \"zip\",\n      \"Latitude\":  37.371991,\n      \"Longitude\": -122.026020,\n      \"Address\":   \"\",\n      \"City\":      \"SUNNYVALE\",\n      \"State\":     \"CA\",\n      \"Zip\":       \"94085\",\n      \"Country\":   \"US\"\n   }\n]\n";
        Syntax.Builder.create().scannerType(JSONScanner.TYPE.getName()).encoderType("TEST").execute(source);
        AssertEncoder.assertTextToken(TokenType.content, "Zip", "precision");
        AssertEncoder.assertTextToken(TokenType.content, "zip", "CA", "US");
        AssertEncoder.assertTextToken(TokenType.integer, "37");
        AssertEncoder.assertTextToken(TokenType.float_, "37.371991", "-122.3959");
    }

    @Test
    public void shouldMatchJSONExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "json", "example.in.json");
    }

    @Test
    public void shouldMatchJSONLibExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "json", "json-lib.in.json");
    }

    @Test
    public void shouldMatchJSONBigExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "json", "big.in.json");
    }

    @Test
    public void shouldMatchJSONBig2Example() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "json", "big2.in.json");
    }
}

