/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.grep;

import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class AeshPosixFilePermissions {
    private AeshPosixFilePermissions() {
    }

    private static void writeBits(StringBuilder sb, boolean r, boolean w, boolean x) {
        if (r) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if (w) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if (x) {
            sb.append('x');
        } else {
            sb.append('-');
        }
    }

    public static String toString(PosixFileAttributes attr) {
        Set<PosixFilePermission> perms = attr.permissions();
        StringBuilder sb = new StringBuilder(10);
        if (attr.isDirectory()) {
            sb.append('d');
        } else if (attr.isSymbolicLink()) {
            sb.append('l');
        } else {
            sb.append('-');
        }
        AeshPosixFilePermissions.writeBits(sb, perms.contains((Object)PosixFilePermission.OWNER_READ), perms.contains((Object)PosixFilePermission.OWNER_WRITE), perms.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        AeshPosixFilePermissions.writeBits(sb, perms.contains((Object)PosixFilePermission.GROUP_READ), perms.contains((Object)PosixFilePermission.GROUP_WRITE), perms.contains((Object)PosixFilePermission.GROUP_EXECUTE));
        AeshPosixFilePermissions.writeBits(sb, perms.contains((Object)PosixFilePermission.OTHERS_READ), perms.contains((Object)PosixFilePermission.OTHERS_WRITE), perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        return sb.toString();
    }
}

