/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.touch;

import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.io.Resource;

@CommandDefinition(name="touch", description="create and change file timestamps")
public class Touch
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=97, name="access time", hasValue=false, description="change only the access time")
    private boolean changeOnlyAccessTime;
    @Option(shortName=109, name="modification time", hasValue=false, description="change only the modification time")
    private boolean changeOnlyModificationTime;
    @Option(shortName=99, name="no create", hasValue=false, description="do not create any files")
    private boolean noCreate;
    @Arguments
    private List<Resource> args;

    public CommandResult execute(CommandInvocation ci) throws IOException {
        if (this.help || this.args == null || this.args.isEmpty()) {
            ci.getShell().out().println(ci.getHelpInfo("touch"));
            return CommandResult.SUCCESS;
        }
        Resource currentDir = ci.getAeshContext().getCurrentWorkingDirectory();
        for (Resource r : this.args) {
            Resource res = (Resource)r.resolve(currentDir).get(0);
            this.touch(res, ci);
        }
        return CommandResult.SUCCESS;
    }

    private void touch(Resource r, CommandInvocation ci) throws IOException {
        if (r.exists()) {
            if (this.changeOnlyAccessTime) {
                r.setLastAccessed(System.currentTimeMillis());
            }
            if (this.changeOnlyModificationTime) {
                r.setLastModified(System.currentTimeMillis());
            }
        } else if (!this.noCreate) {
            this.create(r, ci);
        }
    }

    private void create(Resource r, CommandInvocation ci) throws IOException {
        ((Resource)r.resolve(ci.getAeshContext().getCurrentWorkingDirectory()).get(0)).write(false);
    }
}

