/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline;

import org.jboss.aesh.readline.BufferString;
import org.jboss.aesh.readline.Prompt;
import org.junit.Assert;
import org.junit.Test;

public class BufferStringTest {
    @Test
    public void testMove() {
        String input = "foo-bar";
        BufferString buffer = new BufferString(true, null);
        buffer.write(input);
        char[] out = buffer.move(-1, 80);
        char[] expected = new char[]{'\u001b', '[', '1', 'D'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)6L, (long)buffer.getCursor());
        out = buffer.move(1, 80);
        expected = new char[]{'\u001b', '[', '1', 'C'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)7L, (long)buffer.getCursor());
        out = buffer.move(-5, 80);
        expected = new char[]{'\u001b', '[', '5', 'D'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)2L, (long)buffer.getCursor());
        out = buffer.move(-3, 80);
        expected = new char[]{'\u001b', '[', '2', 'D'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)0L, (long)buffer.getCursor());
        out = buffer.move(-3, 80);
        expected = new char[]{};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)0L, (long)buffer.getCursor());
        out = buffer.move(10, 80);
        expected = new char[]{'\u001b', '[', '7', 'C'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)7L, (long)buffer.getCursor());
        String prompt = "foo@bar:";
        buffer.reset(new Prompt(prompt));
        buffer.write(input);
        out = buffer.move(-1, 80);
        expected = new char[]{'\u001b', '[', '1', 'D'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)(input.length() - 1), (long)buffer.getCursor());
        Assert.assertEquals((long)(prompt.length() + input.length()), (long)buffer.getCursorWithPrompt());
        out = buffer.move(1, 80);
        expected = new char[]{'\u001b', '[', '1', 'C'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)7L, (long)buffer.getCursor());
        out = buffer.move(-5, 80);
        expected = new char[]{'\u001b', '[', '5', 'D'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)2L, (long)buffer.getCursor());
        out = buffer.move(-6, 80);
        expected = new char[]{'\u001b', '[', '2', 'D'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)0L, (long)buffer.getCursor());
        out = buffer.move(10, 80);
        expected = new char[]{'\u001b', '[', '7', 'C'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(out));
        Assert.assertEquals((long)7L, (long)buffer.getCursor());
        buffer.reset(new Prompt(">"));
        buffer.write("foo");
        buffer.move(-4, 80, true);
        Assert.assertEquals((long)2L, (long)buffer.getCursorWithPrompt());
        buffer.move(5, 80, true);
        Assert.assertEquals((long)4L, (long)buffer.getCursorWithPrompt());
        buffer.move(-4, 80, true);
        Assert.assertEquals((long)2L, (long)buffer.getCursorWithPrompt());
    }

    @Test
    public void testPrintAnsi() {
        char[] expected = new char[]{'\u001b', '[', 'J'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(BufferString.printAnsi((String)"J")));
        expected = new char[]{'\u001b', '[', 'J', 'p'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(BufferString.printAnsi((String)"Jp")));
        expected = new char[]{'\u001b', '[', ' ', ' ', ' ', ' '};
        Assert.assertEquals((Object)new String(expected), (Object)new String(BufferString.printAnsi((String)"\t")));
        expected = new char[]{'\u001b', '[', ' ', ' ', ' ', ' ', 'B'};
        Assert.assertEquals((Object)new String(expected), (Object)new String(BufferString.printAnsi((String)"\tB")));
    }
}

