/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.function.Consumer;

public class Decoder {
    private CharsetDecoder decoder;
    private Consumer<int[]> out;

    public Decoder(Charset charset, Consumer<int[]> out) {
        this.decoder = charset.newDecoder();
        this.out = out;
    }

    public void setConsumer(Consumer<int[]> out) {
        this.out = out;
    }

    public void write(byte[] data) {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int start, int len) {
        this.decode(data, start, len);
    }

    private void decode(byte[] ba, int off, int len) {
        int en = Decoder.scale(len, this.decoder.maxCharsPerByte());
        char[] ca = new char[en];
        if (len == 0) {
            return;
        }
        this.decoder.reset();
        ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
        CharBuffer cb = CharBuffer.wrap(ca);
        try {
            CoderResult cr = this.decoder.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = this.decoder.flush(cb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        this.parseChars(ca);
    }

    private static int scale(int len, float expansionFactor) {
        return (int)((double)len * (double)expansionFactor);
    }

    private void parseChars(char[] chars) {
        int[] ints = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            ints[i] = chars[i];
        }
        if (this.out != null) {
            this.out.accept(ints);
        }
    }
}

