/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Consumer;

public class Encoder
implements Consumer<int[]> {
    private final Charset charset;
    private final Consumer<byte[]> out;

    public Encoder(Charset charset, Consumer<byte[]> out) {
        this.charset = charset;
        this.out = out;
    }

    @Override
    public void accept(int[] input) {
        char[] tmp = new char[2];
        int capacity = 0;
        for (int codePoint : input) {
            capacity += Character.charCount(codePoint);
        }
        CharBuffer charBuf = CharBuffer.allocate(capacity);
        for (int in : input) {
            int size = Character.toChars(in, tmp, 0);
            charBuf.put(tmp, 0, size);
        }
        charBuf.flip();
        ByteBuffer bytesBuf = this.charset.encode(charBuf);
        this.out.accept(Encoder.safeTrim(bytesBuf.array(), bytesBuf.limit()));
    }

    private static byte[] safeTrim(byte[] bytes, int length) {
        if (bytes.length == length) {
            return bytes;
        }
        return Arrays.copyOf(bytes, length);
    }
}

