/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.action.mappings;

import java.util.Arrays;
import org.jboss.aesh.readline.ConsoleBuffer;
import org.jboss.aesh.readline.InputProcessor;
import org.jboss.aesh.readline.action.Action;

public class DeleteChar
implements Action {
    private boolean viMode = false;

    public DeleteChar() {
    }

    public DeleteChar(boolean viMode) {
        this.viMode = viMode;
    }

    @Override
    public String name() {
        return "delete-char";
    }

    @Override
    public void apply(InputProcessor inputProcessor) {
        this.deleteNoMasking(inputProcessor.getBuffer());
    }

    private void deleteNoMasking(ConsoleBuffer consoleBuffer) {
        int lineSize;
        int cursor = consoleBuffer.getBuffer().getCursor();
        if (cursor < (lineSize = consoleBuffer.getBuffer().length())) {
            consoleBuffer.addActionToUndoStack();
            consoleBuffer.getPasteManager().addText(Arrays.copyOfRange(consoleBuffer.getBuffer().getMultiLine(), cursor, cursor + 1));
            consoleBuffer.delete(1);
            if (cursor == lineSize - 1 && cursor > 0 && this.viMode) {
                consoleBuffer.moveCursor(-1);
            }
        }
    }
}

