/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.readline.editing;

import java.io.InputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aesh.readline.action.mappings.BackwardChar;
import org.jboss.aesh.readline.action.mappings.BeginningOfLine;
import org.jboss.aesh.readline.action.mappings.ChangeCaseChar;
import org.jboss.aesh.readline.action.mappings.CopyBackwardBigWord;
import org.jboss.aesh.readline.action.mappings.CopyBackwardWord;
import org.jboss.aesh.readline.action.mappings.CopyForwardBigWord;
import org.jboss.aesh.readline.action.mappings.CopyForwardWord;
import org.jboss.aesh.readline.action.mappings.CopyLine;
import org.jboss.aesh.readline.action.mappings.DeleteBackwardBigWord;
import org.jboss.aesh.readline.action.mappings.DeleteBackwardWord;
import org.jboss.aesh.readline.action.mappings.DeleteChar;
import org.jboss.aesh.readline.action.mappings.DeleteEndOfLine;
import org.jboss.aesh.readline.action.mappings.DeleteForwardBigWord;
import org.jboss.aesh.readline.action.mappings.DeleteForwardWord;
import org.jboss.aesh.readline.action.mappings.DeletePrevChar;
import org.jboss.aesh.readline.action.mappings.DeleteStartOfLine;
import org.jboss.aesh.readline.action.mappings.EndOfLine;
import org.jboss.aesh.readline.action.mappings.ForwardChar;
import org.jboss.aesh.readline.action.mappings.Interrupt;
import org.jboss.aesh.readline.action.mappings.MoveBackwardBigWord;
import org.jboss.aesh.readline.action.mappings.MoveBackwardWord;
import org.jboss.aesh.readline.action.mappings.MoveForwardBigWord;
import org.jboss.aesh.readline.action.mappings.MoveForwardWord;
import org.jboss.aesh.readline.action.mappings.NextHistory;
import org.jboss.aesh.readline.action.mappings.NoAction;
import org.jboss.aesh.readline.action.mappings.PrevHistory;
import org.jboss.aesh.readline.action.mappings.Undo;
import org.jboss.aesh.readline.editing.EditMode;
import org.jboss.aesh.readline.editing.Emacs;
import org.jboss.aesh.readline.editing.InputrcParser;
import org.jboss.aesh.readline.editing.Variable;
import org.jboss.aesh.readline.editing.Vi;
import org.jboss.aesh.terminal.Key;

public class EditModeBuilder {
    private Map<int[], String> actions = new HashMap<int[], String>();
    private Map<Variable, String> variables = new EnumMap<Variable, String>(Variable.class);

    private EditModeBuilder(EditMode.Mode mode) {
        this();
        if (mode == EditMode.Mode.EMACS) {
            this.variables.put(Variable.EDITING_MODE, "emacs");
        } else {
            this.variables.put(Variable.EDITING_MODE, "vi");
        }
    }

    private EditModeBuilder() {
    }

    public static EditModeBuilder builder() {
        return new EditModeBuilder();
    }

    public static EditModeBuilder builder(EditMode.Mode mode) {
        return new EditModeBuilder(mode);
    }

    public EditModeBuilder addAction(int[] input, String action) {
        this.actions.put(input, action);
        return this;
    }

    public EditModeBuilder addVariable(Variable variable, String value) {
        this.variables.put(variable, value);
        return this;
    }

    public EditModeBuilder parseInputrc(InputStream inputStream) {
        InputrcParser.parseInputrc(inputStream, this);
        return this;
    }

    public String getVariableValue(Variable variable) {
        return this.variables.get((Object)variable);
    }

    public EditMode createSimple() {
        Emacs simpleEmacs = new Emacs();
        simpleEmacs.clearDefaultActions();
        simpleEmacs.addAction(Key.ENTER, "accept-line");
        simpleEmacs.addAction(Key.ENTER_2, "accept-line");
        simpleEmacs.addAction(Key.CTRL_L, "accept-line");
        simpleEmacs.addAction(Key.CTRL_M, "accept-line");
        return simpleEmacs;
    }

    public EditMode create() {
        String mode = this.variables.getOrDefault((Object)Variable.EDITING_MODE, "emacs");
        if (mode.equals("vi")) {
            EditMode editMode = this.createDefaultViMode();
            this.actions.forEach(editMode::addAction);
            this.variables.forEach(editMode::addVariable);
            return editMode;
        }
        EditMode editMode = this.createDefaultEmacsMode();
        this.actions.forEach(editMode::addAction);
        this.variables.forEach(editMode::addVariable);
        return editMode;
    }

    private EditMode createDefaultEmacsMode() {
        Emacs emacs = new Emacs();
        emacs.addAction(Key.CTRL_A, "beginning-of-line");
        emacs.addAction(Key.CTRL_B, "backward-char");
        emacs.addAction(Key.CTRL_D, "delete-char");
        emacs.addAction(Key.CTRL_E, "end-of-line");
        emacs.addAction(Key.CTRL_F, "forward-char");
        emacs.addAction(Key.CTRL_H, "backward-delete-char");
        emacs.addAction(Key.CTRL_K, "kill-line");
        emacs.addAction(Key.CTRL_U, "unix-line-discard");
        emacs.addAction(Key.CTRL_J, "accept-line");
        emacs.addAction(Key.CTRL_M, "accept-line");
        emacs.addAction(Key.ENTER, "accept-line");
        emacs.addAction(Key.ENTER_2, "accept-line");
        emacs.addAction(Key.UP, "previous-history");
        emacs.addAction(Key.UP_2, "previous-history");
        emacs.addAction(Key.CTRL_P, "previous-history");
        emacs.addAction(Key.DOWN, "next-history");
        emacs.addAction(Key.DOWN_2, "next-history");
        emacs.addAction(Key.CTRL_N, "next-history");
        emacs.addAction(Key.LEFT, "backward-char");
        emacs.addAction(Key.LEFT_2, "backward-char");
        emacs.addAction(Key.RIGHT, "forward-char");
        emacs.addAction(Key.RIGHT_2, "forward-char");
        emacs.addAction(Key.BACKSPACE, "backward-delete-char");
        emacs.addAction(Key.DELETE, "delete-char");
        emacs.addAction(Key.CTRL_I, "complete");
        emacs.addAction(Key.CTRL_C, new Interrupt());
        emacs.addAction(Key.META_b, "backward-word");
        emacs.addAction(Key.META_c, "capitalize-word");
        emacs.addAction(Key.META_f, "forward-word");
        emacs.addAction(Key.META_d, "kill-word");
        emacs.addAction(Key.META_l, "downcase-word");
        emacs.addAction(Key.META_u, "upcase-word");
        emacs.addAction(Key.META_BACKSPACE, "backward-kill-word");
        emacs.addAction(Key.CTRL_W, "unix-word-rubout");
        emacs.addAction(Key.CTRL_X_CTRL_U, "undo");
        emacs.addAction(Key.UNIT_SEPARATOR, "undo");
        emacs.addAction(Key.CTRL_R, "reverse-search-history");
        emacs.addAction(Key.CTRL_S, "forward-search-history");
        emacs.addAction(Key.CTRL_L, "clear-screen");
        emacs.addAction(Key.ESC, "no-action");
        return emacs;
    }

    private EditMode createDefaultViMode() {
        Vi vi = new Vi();
        if (Key.ENTER.equals(Key.ENTER_2)) {
            vi.addActionGroup(Key.ENTER, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus("accept-line", EditMode.Status.EDIT, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.COMMAND, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus("accept-line", EditMode.Status.CHANGE, EditMode.Status.COMMAND)}));
            vi.addActionGroup(Key.CTRL_M, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus("accept-line", EditMode.Status.EDIT, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.COMMAND, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus("accept-line", EditMode.Status.CHANGE, EditMode.Status.COMMAND)}));
        } else {
            vi.addActionGroup(Key.ENTER, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus("accept-line", EditMode.Status.EDIT, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.COMMAND, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus("accept-line", EditMode.Status.CHANGE, EditMode.Status.COMMAND)}));
            vi.addActionGroup(Key.ENTER_2, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus("accept-line", EditMode.Status.EDIT, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.COMMAND, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus("accept-line", EditMode.Status.CHANGE, EditMode.Status.COMMAND)}));
            vi.addActionGroup(Key.CTRL_M, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus("accept-line", EditMode.Status.EDIT, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.COMMAND, EditMode.Status.EDIT), new Vi.ActionStatus("accept-line", EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus("accept-line", EditMode.Status.CHANGE, EditMode.Status.COMMAND)}));
        }
        vi.addActionGroup(Key.CTRL_C, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new Interrupt(), EditMode.Status.EDIT, EditMode.Status.EDIT), new Vi.ActionStatus(new Interrupt(), EditMode.Status.COMMAND, EditMode.Status.EDIT), new Vi.ActionStatus(new Interrupt(), EditMode.Status.CHANGE, EditMode.Status.EDIT), new Vi.ActionStatus(new Interrupt(), EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addAction(Key.CTRL_I, "complete");
        vi.addAction(Key.CTRL_L, "clear-screen");
        vi.addAction(Key.CTRL_Z, new NoAction());
        vi.addAction(Key.CTRL_J, "accept-line");
        vi.addAction(Key.CTRL_R, "reverse-search-history");
        vi.addAction(Key.CTRL_S, "forward-search-history");
        vi.addActionGroup(Key.ESC, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new BackwardChar(), EditMode.Status.EDIT, EditMode.Status.COMMAND), new Vi.ActionStatus(new NoAction(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new BackwardChar(), EditMode.Status.CHANGE, EditMode.Status.COMMAND), new Vi.ActionStatus(new NoAction(), EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus(new NoAction(), EditMode.Status.REPLACE, EditMode.Status.COMMAND), new Vi.ActionStatus(new NoAction(), EditMode.Status.YANK, EditMode.Status.COMMAND)}));
        vi.addActionGroup(Key.d, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new NoAction(), EditMode.Status.COMMAND, EditMode.Status.DELETE), new Vi.ActionStatus("kill-whole-line", EditMode.Status.DELETE, EditMode.Status.COMMAND)}));
        vi.addActionGroup(Key.c, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new NoAction(), EditMode.Status.COMMAND, EditMode.Status.CHANGE), new Vi.ActionStatus("kill-whole-line", EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addActionGroup(Key.y, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new NoAction(), EditMode.Status.COMMAND, EditMode.Status.YANK), new Vi.ActionStatus(new CopyLine(), EditMode.Status.YANK, EditMode.Status.COMMAND)}));
        vi.addAction(Key.s, "delete-char", EditMode.Status.COMMAND, EditMode.Status.EDIT);
        vi.addAction(Key.S, "kill-whole-line", EditMode.Status.COMMAND, EditMode.Status.EDIT);
        vi.addAction(Key.D, new DeleteEndOfLine(true), EditMode.Status.COMMAND, EditMode.Status.COMMAND, EditMode.Status.DELETE);
        vi.addAction(Key.C, new DeleteEndOfLine(), EditMode.Status.COMMAND, EditMode.Status.EDIT, EditMode.Status.CHANGE);
        vi.addAction(Key.a, "forward-char", EditMode.Status.COMMAND, EditMode.Status.EDIT);
        vi.addAction(Key.A, "end-of-line", EditMode.Status.COMMAND, EditMode.Status.EDIT);
        vi.addAction(Key.x, new DeleteChar(true), EditMode.Status.COMMAND, EditMode.Status.COMMAND, EditMode.Status.DELETE);
        vi.addAction(Key.X, new DeletePrevChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND, EditMode.Status.DELETE);
        vi.addAction(Key.P, "yank", EditMode.Status.COMMAND, EditMode.Status.COMMAND);
        vi.addAction(Key.p, "yank-after", EditMode.Status.COMMAND, EditMode.Status.COMMAND);
        vi.addAction(Key.i, new NoAction(), EditMode.Status.COMMAND, EditMode.Status.EDIT);
        vi.addAction(Key.I, "beginning-of-line", EditMode.Status.COMMAND, EditMode.Status.EDIT);
        vi.addAction(Key.TILDE, new ChangeCaseChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND, EditMode.Status.CHANGE);
        vi.addAction(Key.r, new NoAction(), EditMode.Status.COMMAND, EditMode.Status.REPLACE);
        vi.addActionGroup(Key.h, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new BackwardChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeletePrevChar(), EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeletePrevChar(), EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addActionGroup(Key.l, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new ForwardChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteChar(), EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteChar(), EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addActionGroup(Key.b, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new MoveBackwardWord(true), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteBackwardWord(true), EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus(new CopyBackwardWord(true), EditMode.Status.YANK, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteBackwardWord(true), EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addActionGroup(Key.w, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new MoveForwardWord(true), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteForwardWord(true), EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus(new CopyForwardWord(true), EditMode.Status.YANK, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteForwardWord(true, EditMode.Status.CHANGE), EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addActionGroup(Key.B, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new MoveBackwardBigWord(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteBackwardBigWord(), EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus(new CopyBackwardBigWord(true), EditMode.Status.YANK, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteBackwardBigWord(), EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addActionGroup(Key.W, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new MoveForwardBigWord(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteForwardBigWord(), EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus(new CopyForwardBigWord(true), EditMode.Status.YANK, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteForwardBigWord(), EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addActionGroup(Key.ZERO, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new BeginningOfLine(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteStartOfLine(), EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus(new DeleteStartOfLine(), EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addActionGroup(Key.DOLLAR, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new EndOfLine(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus("kill-line", EditMode.Status.DELETE, EditMode.Status.COMMAND), new Vi.ActionStatus("kill-line", EditMode.Status.CHANGE, EditMode.Status.EDIT)}));
        vi.addAction(Key.k, "previous-history", EditMode.Status.COMMAND, EditMode.Status.COMMAND);
        vi.addAction(Key.j, "next-history", EditMode.Status.COMMAND, EditMode.Status.COMMAND);
        vi.addAction(Key.SPACE, "forward-char", EditMode.Status.COMMAND, EditMode.Status.COMMAND);
        vi.addAction(Key.PERIOD, new NoAction(), EditMode.Status.COMMAND, EditMode.Status.REPEAT);
        vi.addAction(Key.u, new Undo(), EditMode.Status.COMMAND, EditMode.Status.COMMAND);
        vi.addAction(Key.BACKSPACE, "backward-delete-char", EditMode.Status.EDIT, EditMode.Status.EDIT);
        if (Key.RIGHT.equalTo(Key.RIGHT_2.getKeyValues())) {
            vi.addActionGroup(Key.RIGHT, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new ForwardChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new ForwardChar(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
        } else {
            vi.addActionGroup(Key.RIGHT, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new ForwardChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new ForwardChar(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
            vi.addActionGroup(Key.RIGHT_2, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new ForwardChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new ForwardChar(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
        }
        if (Key.LEFT.equalTo(Key.LEFT_2.getKeyValues())) {
            vi.addActionGroup(Key.LEFT, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new BackwardChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new BackwardChar(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
        } else {
            vi.addActionGroup(Key.LEFT, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new BackwardChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new BackwardChar(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
            vi.addActionGroup(Key.LEFT_2, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new BackwardChar(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new BackwardChar(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
        }
        if (Key.UP.equalTo(Key.UP_2.getKeyValues())) {
            vi.addActionGroup(Key.UP, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new PrevHistory(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new PrevHistory(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
        } else {
            vi.addActionGroup(Key.UP, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new PrevHistory(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new PrevHistory(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
            vi.addActionGroup(Key.UP_2, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new PrevHistory(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new PrevHistory(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
        }
        if (Key.DOWN.equalTo(Key.DOWN_2.getKeyValues())) {
            vi.addActionGroup(Key.DOWN, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new NextHistory(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new NextHistory(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
        } else {
            vi.addActionGroup(Key.DOWN, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new NextHistory(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new NextHistory(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
            vi.addActionGroup(Key.DOWN_2, new Vi.ActionStatusGroup(new Vi.ActionStatus[]{new Vi.ActionStatus(new NextHistory(), EditMode.Status.COMMAND, EditMode.Status.COMMAND), new Vi.ActionStatus(new NextHistory(), EditMode.Status.EDIT, EditMode.Status.EDIT)}));
        }
        if (Key.HOME.equalTo(Key.HOME_2.getKeyValues())) {
            vi.addAction(Key.HOME, new BeginningOfLine(), EditMode.Status.EDIT, EditMode.Status.EDIT);
        } else {
            vi.addAction(Key.HOME, new BeginningOfLine(), EditMode.Status.EDIT, EditMode.Status.EDIT);
            vi.addAction(Key.HOME_2, new BeginningOfLine(), EditMode.Status.EDIT, EditMode.Status.EDIT);
        }
        if (Key.END.equalTo(Key.END_2.getKeyValues())) {
            vi.addAction(Key.END, new EndOfLine(), EditMode.Status.EDIT, EditMode.Status.EDIT);
        } else {
            vi.addAction(Key.END, new EndOfLine(), EditMode.Status.EDIT, EditMode.Status.EDIT);
            vi.addAction(Key.END_2, new EndOfLine(), EditMode.Status.EDIT, EditMode.Status.EDIT);
        }
        vi.addAction(Key.CTRL_UP, new EndOfLine(), EditMode.Status.EDIT, EditMode.Status.EDIT);
        vi.addAction(Key.CTRL_DOWN, new BeginningOfLine(), EditMode.Status.EDIT, EditMode.Status.EDIT);
        vi.addAction(Key.CTRL_LEFT, new MoveBackwardBigWord(), EditMode.Status.EDIT, EditMode.Status.EDIT);
        vi.addAction(Key.CTRL_RIGHT, new MoveForwardBigWord(), EditMode.Status.EDIT, EditMode.Status.EDIT);
        vi.addAction(Key.DELETE, "delete-char", EditMode.Status.EDIT, EditMode.Status.EDIT);
        return vi;
    }
}

