/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.util.EnumSet;

public class Attributes {
    long c_iflag;
    long c_oflag;
    long c_cflag;
    long c_lflag;
    byte[] c_cc = new byte[20];

    public Attributes() {
    }

    public Attributes(Attributes attr) {
        this.copy(attr);
    }

    public EnumSet<InputFlag> getInputFlags() {
        EnumSet<InputFlag> flags = EnumSet.noneOf(InputFlag.class);
        for (InputFlag flag : InputFlag.values()) {
            if (!this.getInputFlag(flag)) continue;
            flags.add(flag);
        }
        return flags;
    }

    public void setInputFlags(EnumSet<InputFlag> flags) {
        int v = 0;
        for (InputFlag f : flags) {
            v |= f.value;
        }
        this.c_iflag = v;
    }

    public boolean getInputFlag(InputFlag flag) {
        return (this.c_iflag & (long)flag.value) == (long)flag.value;
    }

    public void setInputFlags(EnumSet<InputFlag> flags, boolean value) {
        int v = 0;
        for (InputFlag f : flags) {
            v |= f.value;
        }
        this.c_iflag = value ? (this.c_iflag |= (long)v) : (this.c_iflag &= (long)(~v));
    }

    public void setInputFlag(InputFlag flag, boolean value) {
        this.c_iflag = value ? (this.c_iflag |= (long)flag.value) : (this.c_iflag &= (long)(~flag.value));
    }

    public EnumSet<OutputFlag> getOutputFlags() {
        EnumSet<OutputFlag> flags = EnumSet.noneOf(OutputFlag.class);
        for (OutputFlag flag : OutputFlag.values()) {
            if (!this.getOutputFlag(flag)) continue;
            flags.add(flag);
        }
        return flags;
    }

    public void setOutputFlags(EnumSet<OutputFlag> flags) {
        int v = 0;
        for (OutputFlag f : flags) {
            v |= f.value;
        }
        this.c_oflag = v;
    }

    public boolean getOutputFlag(OutputFlag flag) {
        return (this.c_oflag & (long)flag.value) == (long)flag.value;
    }

    public void setOutputFlags(EnumSet<OutputFlag> flags, boolean value) {
        int v = 0;
        for (OutputFlag f : flags) {
            v |= f.value;
        }
        this.c_oflag = value ? (this.c_oflag |= (long)v) : (this.c_oflag &= (long)(~v));
    }

    public void setOutputFlag(OutputFlag flag, boolean value) {
        this.c_oflag = value ? (this.c_oflag |= (long)flag.value) : (this.c_oflag &= (long)(~flag.value));
    }

    public EnumSet<ControlFlag> getControlFlags() {
        EnumSet<ControlFlag> flags = EnumSet.noneOf(ControlFlag.class);
        for (ControlFlag flag : ControlFlag.values()) {
            if (!this.getControlFlag(flag)) continue;
            flags.add(flag);
        }
        return flags;
    }

    public void setControlFlags(EnumSet<ControlFlag> flags) {
        int v = 0;
        for (ControlFlag f : flags) {
            v |= f.value;
        }
        this.c_cflag = v;
    }

    public boolean getControlFlag(ControlFlag flag) {
        switch (flag) {
            case CS5: 
            case CS6: 
            case CS7: 
            case CS8: {
                return (this.c_cflag & (long)ControlFlag.CSIZE.value) == (long)flag.value;
            }
            case CSIZE: {
                return false;
            }
        }
        return (this.c_cflag & (long)flag.value) == (long)flag.value;
    }

    public void setControlFlags(EnumSet<ControlFlag> flags, boolean value) {
        int v = 0;
        for (ControlFlag f : flags) {
            v |= f.value;
        }
        this.c_cflag = value ? (this.c_cflag |= (long)v) : (this.c_cflag &= (long)(~v));
    }

    public void setControlFlag(ControlFlag flag, boolean value) {
        this.c_cflag = value ? (this.c_cflag |= (long)flag.value) : (this.c_cflag &= (long)(~flag.value));
    }

    public EnumSet<LocalFlag> getLocalFlags() {
        EnumSet<LocalFlag> flags = EnumSet.noneOf(LocalFlag.class);
        for (LocalFlag flag : LocalFlag.values()) {
            if (!this.getLocalFlag(flag)) continue;
            flags.add(flag);
        }
        return flags;
    }

    public void setLocalFlags(EnumSet<LocalFlag> flags) {
        int v = 0;
        for (LocalFlag f : flags) {
            v |= f.value;
        }
        this.c_lflag = v;
    }

    public boolean getLocalFlag(LocalFlag flag) {
        return (this.c_lflag & (long)flag.value) == (long)flag.value;
    }

    public void setLocalFlags(EnumSet<LocalFlag> flags, boolean value) {
        int v = 0;
        for (LocalFlag f : flags) {
            v |= f.value;
        }
        this.c_lflag = value ? (this.c_lflag |= (long)v) : (this.c_lflag &= (long)(~v));
    }

    public void setLocalFlag(LocalFlag flag, boolean value) {
        this.c_lflag = value ? (this.c_lflag |= (long)flag.value) : (this.c_lflag &= (long)(~flag.value));
    }

    public int getControlChar(ControlChar c) {
        return this.c_cc[c.value] & 0xFF;
    }

    public void setControlChar(ControlChar c, int value) {
        this.c_cc[c.value] = (byte)value;
    }

    public void copy(Attributes attributes) {
        System.arraycopy(attributes.c_cc, 0, this.c_cc, 0, this.c_cc.length);
        this.c_cflag = attributes.c_cflag;
        this.c_iflag = attributes.c_iflag;
        this.c_lflag = attributes.c_lflag;
        this.c_oflag = attributes.c_oflag;
    }

    public static enum LocalFlag {
        ECHOKE(1),
        ECHOE(2),
        ECHOK(4),
        ECHO(8),
        ECHONL(16),
        ECHOPRT(32),
        ECHOCTL(64),
        ISIG(128),
        ICANON(256),
        ALTWERASE(512),
        IEXTEN(1024),
        EXTPROC(2048),
        TOSTOP(0x400000),
        FLUSHO(0x800000),
        NOKERNINFO(0x2000000),
        PENDIN(0x20000000),
        NOFLSH(Integer.MIN_VALUE);

        final int value;

        private LocalFlag(int value) {
            this.value = value;
        }
    }

    public static enum ControlFlag {
        CIGNORE(1),
        CSIZE(768),
        CS5(0),
        CS6(256),
        CS7(512),
        CS8(768),
        CSTOPB(1024),
        CREAD(2048),
        PARENB(4096),
        PARODD(8192),
        HUPCL(16384),
        CLOCAL(32768),
        CCTS_OFLOW(65536),
        CRTS_IFLOW(131072),
        CRTSCTS(ControlFlag.CCTS_OFLOW.value | ControlFlag.CRTS_IFLOW.value),
        CDTR_IFLOW(262144),
        CDSR_OFLOW(524288),
        CCAR_OFLOW(0x100000);

        final int value;

        private ControlFlag(int value) {
            this.value = value;
        }
    }

    public static enum OutputFlag {
        OPOST(1),
        ONLCR(2),
        OXTABS(4),
        ONOEOT(8),
        OCRNL(16),
        ONOCR(32),
        ONLRET(64),
        OFILL(128),
        NLDLY(768),
        TABDLY(3076),
        CRDLY(12288),
        FFDLY(16384),
        BSDLY(32768),
        VTDLY(65536),
        OFDEL(131072);

        final int value;

        private OutputFlag(int value) {
            this.value = value;
        }
    }

    public static enum InputFlag {
        IGNBRK(1),
        BRKINT(2),
        IGNPAR(4),
        PARMRK(8),
        INPCK(16),
        ISTRIP(32),
        INLCR(64),
        IGNCR(128),
        ICRNL(256),
        IXON(512),
        IXOFF(1024),
        IXANY(2048),
        IMAXBEL(8192),
        IUTF8(16384);

        final int value;

        private InputFlag(int value) {
            this.value = value;
        }
    }

    public static enum ControlChar {
        VEOF(0),
        VEOL(1),
        VEOL2(2),
        VERASE(3),
        VWERASE(4),
        VKILL(5),
        VREPRINT(6),
        VINTR(8),
        VQUIT(9),
        VSUSP(10),
        VDSUSP(11),
        VSTART(12),
        VSTOP(13),
        VLNEXT(14),
        VDISCARD(15),
        VMIN(16),
        VTIME(17),
        VSTATUS(18);

        final int value;

        private ControlChar(int value) {
            this.value = value;
        }
    }
}

