/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import org.jboss.aesh.terminal.Attributes;
import org.jboss.aesh.terminal.impl.AbstractTerminal;
import org.jboss.aesh.terminal.impl.Pty;
import org.jboss.aesh.tty.Size;

public abstract class AbstractPosixTerminal
extends AbstractTerminal {
    protected final Pty pty;
    protected final Attributes originalAttributes;

    public AbstractPosixTerminal(String name, String type, Pty pty) throws IOException {
        super(name, type);
        assert (pty != null);
        this.pty = pty;
        this.originalAttributes = this.pty.getAttr();
    }

    protected Pty getPty() {
        return this.pty;
    }

    @Override
    public Attributes getAttributes() {
        try {
            return this.pty.getAttr();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void setAttributes(Attributes attr) {
        try {
            this.pty.setAttr(attr);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public Size getSize() {
        try {
            return this.pty.getSize();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.pty.setAttr(this.originalAttributes);
        this.pty.close();
    }
}

