/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.terminal.Attributes;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.utils.Curses;
import org.jboss.aesh.terminal.utils.InfoCmp;
import org.jboss.aesh.tty.Capability;
import org.jboss.aesh.tty.Signal;
import org.jboss.aesh.util.LoggerUtil;

public abstract class AbstractTerminal
implements Terminal {
    protected final Logger LOGGER = LoggerUtil.getLogger(this.getClass().getName());
    protected final String name;
    protected final String type;
    protected final Map<Signal, Terminal.SignalHandler> handlers = new HashMap<Signal, Terminal.SignalHandler>();
    protected final Set<Capability> bools = new HashSet<Capability>();
    protected final Map<Capability, Integer> ints = new HashMap<Capability, Integer>();
    protected final Map<Capability, String> strings = new HashMap<Capability, String>();

    public AbstractTerminal(String name, String type) throws IOException {
        this.name = name;
        this.type = type;
        for (Signal signal : Signal.values()) {
            this.handlers.put(signal, Terminal.SignalHandler.SIG_DFL);
        }
    }

    @Override
    public Terminal.SignalHandler handle(Signal signal, Terminal.SignalHandler handler) {
        assert (signal != null);
        assert (handler != null);
        return this.handlers.put(signal, handler);
    }

    @Override
    public void raise(Signal signal) {
        assert (signal != null);
        Terminal.SignalHandler handler = this.handlers.get((Object)signal);
        if (handler == Terminal.SignalHandler.SIG_DFL) {
            this.handleDefaultSignal(signal);
        } else if (handler != Terminal.SignalHandler.SIG_IGN) {
            handler.handle(signal);
        }
    }

    protected void handleDefaultSignal(Signal signal) {
    }

    protected void echoSignal(Signal signal) {
        int vcc;
        Attributes.ControlChar cc = null;
        switch (signal) {
            case INT: {
                cc = Attributes.ControlChar.VINTR;
                break;
            }
            case QUIT: {
                cc = Attributes.ControlChar.VQUIT;
                break;
            }
            case TSTP: {
                cc = Attributes.ControlChar.VSUSP;
            }
        }
        if (cc != null && (vcc = this.getAttributes().getControlChar(cc)) > 0 && vcc < 32) {
            this.writer().write(new char[]{'^', (char)(vcc + 64)}, 0, 2);
        }
    }

    @Override
    public Attributes enterRawMode() {
        Attributes prvAttr = this.getAttributes();
        Attributes newAttr = new Attributes(prvAttr);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        newAttr.setControlChar(Attributes.ControlChar.VMIN, 1);
        newAttr.setControlChar(Attributes.ControlChar.VTIME, 0);
        this.setAttributes(newAttr);
        return prvAttr;
    }

    @Override
    public boolean echo() {
        return this.getAttributes().getLocalFlag(Attributes.LocalFlag.ECHO);
    }

    @Override
    public boolean echo(boolean echo) {
        Attributes attr = this.getAttributes();
        boolean prev = attr.getLocalFlag(Attributes.LocalFlag.ECHO);
        if (prev != echo) {
            attr.setLocalFlag(Attributes.LocalFlag.ECHO, echo);
            this.setAttributes(attr);
        }
        return prev;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    @Override
    public boolean puts(Capability capability, Object ... params) {
        String str = this.getStringCapability(capability);
        if (str == null) {
            return false;
        }
        try {
            Curses.tputs(this.writer(), str, params);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return true;
    }

    @Override
    public boolean getBooleanCapability(Capability capability) {
        return this.bools.contains((Object)capability);
    }

    @Override
    public Integer getNumericCapability(Capability capability) {
        return this.ints.get((Object)capability);
    }

    @Override
    public String getStringCapability(Capability capability) {
        return this.strings.get((Object)capability);
    }

    protected void parseInfoCmp() {
        String capabilities = null;
        if (this.type != null) {
            try {
                capabilities = InfoCmp.getInfoCmp(this.type);
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, "Unable to retrieve infocmp for type " + this.type, e);
            }
        }
        if (capabilities == null) {
            capabilities = "ansi|ansi/pc-term compatible with color,\n\tam, mc5i, mir, msgr,\n\tcolors#8, cols#80, it#8, lines#24, ncv#3, pairs#64,\n\tacsc=+\\020\\,\\021-\\030.^Y0\\333`\\004a\\261f\\370g\\361h\\260j\\331k\\277l\\332m\\300n\\305o~p\\304q\\304r\\304s_t\\303u\\264v\\301w\\302x\\263y\\363z\\362{\\343|\\330}\\234~\\376,\n\tbel=^G, blink=\\E[5m, bold=\\E[1m, cbt=\\E[Z, clear=\\E[H\\E[J,\n\tcr=^M, cub=\\E[%p1%dD, cub1=\\E[D, cud=\\E[%p1%dB, cud1=\\E[B,\n\tcuf=\\E[%p1%dC, cuf1=\\E[C, cup=\\E[%i%p1%d;%p2%dH,\n\tcuu=\\E[%p1%dA, cuu1=\\E[A, dch=\\E[%p1%dP, dch1=\\E[P,\n\tdl=\\E[%p1%dM, dl1=\\E[M, ech=\\E[%p1%dX, ed=\\E[J, el=\\E[K,\n\tel1=\\E[1K, home=\\E[H, hpa=\\E[%i%p1%dG, ht=\\E[I, hts=\\EH,\n\tich=\\E[%p1%d@, il=\\E[%p1%dL, il1=\\E[L, ind=^J,\n\tindn=\\E[%p1%dS, invis=\\E[8m, kbs=^H, kcbt=\\E[Z, kcub1=\\E[D,\n\tkcud1=\\E[B, kcuf1=\\E[C, kcuu1=\\E[A, khome=\\E[H, kich1=\\E[L,\n\tmc4=\\E[4i, mc5=\\E[5i, nel=\\r\\E[S, op=\\E[39;49m,\n\trep=%p1%c\\E[%p2%{1}%-%db, rev=\\E[7m, rin=\\E[%p1%dT,\n\trmacs=\\E[10m, rmpch=\\E[10m, rmso=\\E[m, rmul=\\E[m,\n\ts0ds=\\E(B, s1ds=\\E)B, s2ds=\\E*B, s3ds=\\E+B,\n\tsetab=\\E[4%p1%dm, setaf=\\E[3%p1%dm,\n\tsgr=\\E[0;10%?%p1%t;7%;%?%p2%t;4%;%?%p3%t;7%;%?%p4%t;5%;%?%p6%t;1%;%?%p7%t;8%;%?%p9%t;11%;m,\n\tsgr0=\\E[0;10m, smacs=\\E[11m, smpch=\\E[11m, smso=\\E[7m,\n\tsmul=\\E[4m, tbc=\\E[2g, u6=\\E[%i%d;%dR, u7=\\E[6n,\n\tu8=\\E[?%[;0123456789]c, u9=\\E[c, vpa=\\E[%i%p1%dd,";
        }
        InfoCmp.parseInfoCmp(capabilities, this.bools, this.ints, this.strings);
    }
}

