/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal.impl;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.fusesource.jansi.internal.Kernel32;
import org.fusesource.jansi.internal.WindowsSupport;
import org.jboss.aesh.terminal.Attributes;
import org.jboss.aesh.terminal.impl.AbstractTerminal;
import org.jboss.aesh.terminal.utils.Curses;
import org.jboss.aesh.terminal.utils.ShutdownHooks;
import org.jboss.aesh.terminal.utils.Signals;
import org.jboss.aesh.tty.Capability;
import org.jboss.aesh.tty.Signal;
import org.jboss.aesh.tty.Size;
import org.jboss.aesh.util.LoggerUtil;

public class WinSysTerminal
extends AbstractTerminal {
    protected final InputStream input;
    protected final OutputStream output;
    protected final PrintWriter writer;
    protected final Map<Signal, Object> nativeHandlers = new HashMap<Signal, Object>();
    protected final ShutdownHooks.Task closer;
    private static final int ENABLE_PROCESSED_INPUT = 1;
    private static final int ENABLE_LINE_INPUT = 2;
    private static final int ENABLE_ECHO_INPUT = 4;
    private static final int ENABLE_WINDOW_INPUT = 8;
    private static final int ENABLE_MOUSE_INPUT = 16;
    private static final int ENABLE_INSERT_MODE = 32;
    private static final int ENABLE_QUICK_EDIT_MODE = 64;
    private static final Logger LOGGER = LoggerUtil.getLogger("WinSySTerminal");

    public WinSysTerminal(String name, boolean nativeSignals) throws IOException {
        super(name, "windows");
        this.input = new DirectInputStream();
        this.output = new WindowsAnsiOutputStream((OutputStream)new FileOutputStream(FileDescriptor.out));
        String encoding = WinSysTerminal.getConsoleEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, encoding));
        this.parseInfoCmp();
        if (nativeSignals) {
            for (Signal signal : Signal.values()) {
                this.nativeHandlers.put(signal, Signals.register(signal.name(), () -> this.raise(signal)));
            }
        }
        this.closer = this::close;
        ShutdownHooks.add(this.closer);
    }

    protected static String getConsoleEncoding() {
        int codepage = Kernel32.GetConsoleOutputCP();
        String charsetMS = "ms" + codepage;
        if (Charset.isSupported(charsetMS)) {
            return charsetMS;
        }
        String charsetCP = "cp" + codepage;
        if (Charset.isSupported(charsetCP)) {
            return charsetCP;
        }
        return null;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public Attributes getAttributes() {
        int mode = WindowsSupport.getConsoleMode();
        Attributes attributes = new Attributes();
        if ((mode & 4) != 0) {
            attributes.setLocalFlag(Attributes.LocalFlag.ECHO, true);
        }
        if ((mode & 2) != 0) {
            attributes.setLocalFlag(Attributes.LocalFlag.ICANON, true);
        }
        return attributes;
    }

    @Override
    public void setAttributes(Attributes attr) {
        int mode = 0;
        if (attr.getLocalFlag(Attributes.LocalFlag.ECHO)) {
            mode |= 4;
        }
        if (attr.getLocalFlag(Attributes.LocalFlag.ICANON)) {
            mode |= 2;
        }
        WindowsSupport.setConsoleMode((int)mode);
    }

    @Override
    public Size getSize() {
        return new Size(WindowsSupport.getWindowsTerminalWidth(), WindowsSupport.getWindowsTerminalHeight());
    }

    @Override
    public void close() throws IOException {
        ShutdownHooks.remove(this.closer);
        for (Map.Entry<Signal, Object> entry : this.nativeHandlers.entrySet()) {
            Signals.unregister(entry.getKey().name(), entry.getValue());
        }
        this.writer.close();
    }

    private byte[] readConsoleInput() {
        Kernel32.INPUT_RECORD[] events = null;
        try {
            events = WindowsSupport.readConsoleInput((int)1);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "read Windows console input error: ", e);
        }
        if (events == null) {
            return new byte[0];
        }
        StringBuilder sb = new StringBuilder();
        for (Kernel32.INPUT_RECORD event : events) {
            boolean isAlt;
            Kernel32.KEY_EVENT_RECORD keyEvent = event.keyEvent;
            int altState = Kernel32.KEY_EVENT_RECORD.LEFT_ALT_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_ALT_PRESSED;
            int ctrlState = Kernel32.KEY_EVENT_RECORD.LEFT_CTRL_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_CTRL_PRESSED;
            boolean bl = isAlt = (keyEvent.controlKeyState & altState) != 0 && (keyEvent.controlKeyState & ctrlState) == 0;
            if (keyEvent.keyDown) {
                if (keyEvent.uchar > '\u0000') {
                    if (isAlt) {
                        sb.append('\u001b');
                    }
                    sb.append(keyEvent.uchar);
                    continue;
                }
                String escapeSequence = null;
                switch (keyEvent.keyCode) {
                    case 8: {
                        escapeSequence = this.getSequence(Capability.key_backspace);
                        break;
                    }
                    case 33: {
                        escapeSequence = this.getSequence(Capability.key_ppage);
                        break;
                    }
                    case 34: {
                        escapeSequence = this.getSequence(Capability.key_npage);
                        break;
                    }
                    case 35: {
                        escapeSequence = this.getSequence(Capability.key_end);
                        break;
                    }
                    case 36: {
                        escapeSequence = this.getSequence(Capability.key_home);
                        break;
                    }
                    case 37: {
                        if (ctrlState == 0) break;
                        escapeSequence = this.getSequence(Capability.key_sleft);
                        break;
                    }
                    case 38: {
                        escapeSequence = this.getSequence(Capability.key_up);
                        break;
                    }
                    case 39: {
                        escapeSequence = this.getSequence(Capability.key_right);
                        break;
                    }
                    case 40: {
                        escapeSequence = this.getSequence(Capability.key_down);
                        break;
                    }
                    case 45: {
                        escapeSequence = this.getSequence(Capability.key_ic);
                        break;
                    }
                    case 46: {
                        escapeSequence = this.getSequence(Capability.key_dc);
                        break;
                    }
                    case 112: {
                        escapeSequence = this.getSequence(Capability.key_f1);
                        break;
                    }
                    case 113: {
                        escapeSequence = this.getSequence(Capability.key_f2);
                        break;
                    }
                    case 114: {
                        escapeSequence = this.getSequence(Capability.key_f3);
                        break;
                    }
                    case 115: {
                        escapeSequence = this.getSequence(Capability.key_f4);
                        break;
                    }
                    case 116: {
                        escapeSequence = this.getSequence(Capability.key_f5);
                        break;
                    }
                    case 117: {
                        escapeSequence = this.getSequence(Capability.key_f6);
                        break;
                    }
                    case 118: {
                        escapeSequence = this.getSequence(Capability.key_f7);
                        break;
                    }
                    case 119: {
                        escapeSequence = this.getSequence(Capability.key_f8);
                        break;
                    }
                    case 120: {
                        escapeSequence = this.getSequence(Capability.key_f9);
                        break;
                    }
                    case 121: {
                        escapeSequence = this.getSequence(Capability.key_f10);
                        break;
                    }
                    case 122: {
                        escapeSequence = this.getSequence(Capability.key_f11);
                        break;
                    }
                    case 123: {
                        escapeSequence = this.getSequence(Capability.key_f12);
                        break;
                    }
                }
                if (escapeSequence == null) continue;
                for (int k = 0; k < keyEvent.repeatCount; ++k) {
                    if (isAlt) {
                        sb.append('\u001b');
                    }
                    sb.append(escapeSequence);
                }
                continue;
            }
            if (keyEvent.keyCode != 18 || keyEvent.uchar <= '\u0000') continue;
            sb.append(keyEvent.uchar);
        }
        return sb.toString().getBytes();
    }

    private String getSequence(Capability cap) {
        String str = (String)this.strings.get((Object)cap);
        if (str != null) {
            StringWriter sw = new StringWriter();
            try {
                Curses.tputs(sw, str, new Object[0]);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            return sw.toString();
        }
        return null;
    }

    private class DirectInputStream
    extends InputStream {
        private byte[] buf = null;
        int bufIdx = 0;

        private DirectInputStream() {
        }

        @Override
        public int read() throws IOException {
            while (this.buf == null || this.bufIdx == this.buf.length) {
                this.buf = WinSysTerminal.this.readConsoleInput();
                this.bufIdx = 0;
            }
            int c = this.buf[this.bufIdx] & 0xFF;
            ++this.bufIdx;
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            if (this.bufIdx == this.buf.length) {
                b[off] = (byte)c;
                return 1;
            }
            b[off] = (byte)c;
            while (this.bufIdx < this.buf.length) {
                c = this.buf[this.bufIdx] & 0xFF;
                b[off + this.bufIdx] = (byte)c;
                ++this.bufIdx;
            }
            return this.bufIdx;
        }
    }
}

