/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.jboss.aesh.util.LoggerUtil;
import org.jboss.aesh.util.Parser;

public class Config {
    private static final boolean windows = System.getProperty("os.name").startsWith("Windows");
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String pathSeparator = System.getProperty("file.separator");
    private static final String tmpDir = System.getProperty("java.io.tmpdir");
    private static final boolean posixCompatible = Config.checkPosixCompability();
    public static final int[] CR = Parser.toCodePoints(lineSeparator);
    private static boolean cygwin = false;
    private static final Logger LOGGER = LoggerUtil.getLogger(Config.class.getName());

    public static boolean isOSPOSIXCompatible() {
        return posixCompatible;
    }

    public static boolean isCygwin() {
        return cygwin;
    }

    public static boolean isWindows() {
        return windows;
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getPathSeparator() {
        return pathSeparator;
    }

    public static String getTmpDir() {
        return tmpDir;
    }

    public static String getHomeDir() {
        return System.getProperty("user.home");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    private static boolean checkPosixCompability() {
        if (Config.isWindows()) {
            try {
                int c;
                Process process = Runtime.getRuntime().exec(new String[]{"uname"});
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream in = process.getInputStream();
                while ((c = in.read()) != -1) {
                    bout.write(c);
                }
                process.waitFor();
                String output = new String(bout.toByteArray());
                if (output.toLowerCase().contains("cygwin")) {
                    cygwin = true;
                    return true;
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            return false;
        }
        return !System.getProperty("os.name").startsWith("OS/2");
    }
}

