/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.ucl.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.aop.classpool.ucl.test.UclClassPoolTest;

public class UclClassLoaderSanityTestCase
extends UclClassPoolTest {
    public UclClassLoaderSanityTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(UclClassLoaderSanityTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGlobalScope() throws Exception {
        ClassLoader clA = null;
        ClassLoader clB = null;
        try {
            Class<?> aFromA;
            clA = this.createGlobalClassLoader(JAR_A_1);
            clB = this.createGlobalClassLoader(JAR_B_1);
            try {
                aFromA = clA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
                UclClassLoaderSanityTestCase.assertNotNull(aFromA);
                Class<?> bFromA = clA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
                UclClassLoaderSanityTestCase.assertNotNull(bFromA);
                Class<?> aFromB = clB.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
                Class<?> bFromB = clB.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
                UclClassLoaderSanityTestCase.assertSame(aFromA, aFromB);
                UclClassLoaderSanityTestCase.assertSame(bFromA, bFromB);
                UclClassLoaderSanityTestCase.assertSame((Object)clA, (Object)aFromA.getClassLoader());
                UclClassLoaderSanityTestCase.assertSame((Object)clB, (Object)bFromB.getClassLoader());
            }
            finally {
                this.removeClassLoaderFromRepository(clB);
            }
            aFromA = clA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromA);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        }
        finally {
            this.removeClassLoaderFromRepository(clA);
        }
        this.assertCannotLoadClass(this.getGlobalRepository(), "org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildDomain() throws Exception {
        ClassLoader clA = null;
        ClassLoader clB = null;
        ClassLoader clC = null;
        try {
            clA = this.createGlobalClassLoader(JAR_A_1);
            clB = this.createGlobalClassLoader(JAR_B_1);
            clC = this.createChildClassLoader(JAR_C_1, false);
            Class<?> aFromA = clA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromA);
            Class<?> bFromB = clB.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclClassLoaderSanityTestCase.assertNotNull(bFromB);
            Class<?> cFromC = clC.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.c.C");
            UclClassLoaderSanityTestCase.assertNotNull(cFromC);
            Class<?> aFromC = clC.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromC);
            Class<?> bFromC = clC.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclClassLoaderSanityTestCase.assertNotNull(bFromC);
            UclClassLoaderSanityTestCase.assertSame(aFromA, aFromC);
            UclClassLoaderSanityTestCase.assertSame(bFromB, bFromC);
            UclClassLoaderSanityTestCase.assertSame((Object)clA, (Object)aFromA.getClassLoader());
            UclClassLoaderSanityTestCase.assertSame((Object)clB, (Object)bFromB.getClassLoader());
            UclClassLoaderSanityTestCase.assertSame((Object)clC, (Object)cFromC.getClassLoader());
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.ucl.support.excluded.c.C");
            this.assertCannotLoadClass(clB, "org.jboss.test.aop.classpool.ucl.support.excluded.c.C");
        }
        finally {
            this.removeClassLoaderFromRepository(clA);
            this.removeClassLoaderFromRepository(clB);
        }
    }

    public void testSiblingDomains() throws Exception {
        ClassLoader clA = this.createChildClassLoader(JAR_A_1, true);
        ClassLoader clB = this.createChildClassLoader(JAR_B_1, false);
        Class<?> clazzA = clA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
        UclClassLoaderSanityTestCase.assertSame((Object)clA, (Object)clazzA.getClassLoader());
        Class<?> clazzB = clB.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        UclClassLoaderSanityTestCase.assertSame((Object)clB, (Object)clazzB.getClassLoader());
        this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        this.assertCannotLoadClass(clB, "org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildWithNewClassesInParent() throws Exception {
        ClassLoader clGlobal = null;
        ClassLoader clScoped = null;
        try {
            clScoped = this.createChildClassLoader(JAR_B_1, true);
            this.assertCannotLoadClass(clScoped, "org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            clGlobal = this.createGlobalClassLoader(JAR_A_1);
            Class<?> aFromChild = clScoped.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromChild);
            Class<?> aFromParent = clGlobal.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromParent);
            UclClassLoaderSanityTestCase.assertSame(aFromChild, aFromParent);
            UclClassLoaderSanityTestCase.assertSame((Object)clGlobal, (Object)aFromParent.getClassLoader());
        }
        catch (Throwable throwable) {
            this.removeClassLoaderFromRepository(clGlobal);
            throw throwable;
        }
        this.removeClassLoaderFromRepository(clGlobal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildOverrideWithParentDelegation() throws Exception {
        ClassLoader clGlobal = null;
        try {
            clGlobal = this.createGlobalClassLoader(JAR_A_1);
            ClassLoader clScoped = this.createChildClassLoader(JAR_A_2, true);
            Class<?> aFromParent = clGlobal.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromParent);
            Class<?> aFromChild = clScoped.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromChild);
            UclClassLoaderSanityTestCase.assertSame(aFromParent, aFromChild);
            UclClassLoaderSanityTestCase.assertSame((Object)clGlobal, (Object)aFromParent.getClassLoader());
        }
        finally {
            this.removeClassLoaderFromRepository(clGlobal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildOverrideWithNoParentDelegation() throws Exception {
        ClassLoader clGlobal = null;
        try {
            clGlobal = this.createGlobalClassLoader(JAR_A_1);
            ClassLoader clScoped = this.createChildClassLoader(JAR_A_2, false);
            Class<?> aFromParent = clGlobal.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromParent);
            Class<?> aFromChild = clScoped.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertNotNull(aFromChild);
            UclClassLoaderSanityTestCase.assertNotSame(aFromParent, aFromChild);
            UclClassLoaderSanityTestCase.assertSame((Object)clGlobal, (Object)aFromParent.getClassLoader());
            UclClassLoaderSanityTestCase.assertSame((Object)clScoped, (Object)aFromChild.getClassLoader());
        }
        finally {
            this.removeClassLoaderFromRepository(clGlobal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURLChildOfGlobalUcl() throws Exception {
        ClassLoader clGlobal = null;
        try {
            clGlobal = this.createGlobalClassLoader(JAR_A_1);
            ClassLoader clChildA = this.createChildURLClassLoader(clGlobal, JAR_B_1);
            Class<?> aFromA = clChildA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertSame((Object)clGlobal, (Object)aFromA.getClassLoader());
            Class<?> bFromA = clChildA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclClassLoaderSanityTestCase.assertSame((Object)clChildA, (Object)bFromA.getClassLoader());
            ClassLoader clChildB = this.createChildURLClassLoader(clGlobal, JAR_A_2);
            Class<?> aFromB = clChildB.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertSame((Object)clGlobal, (Object)aFromB.getClassLoader());
        }
        finally {
            this.removeClassLoaderFromRepository(clGlobal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUndeploySibling() throws Exception {
        ClassLoader clA = null;
        ClassLoader clB = null;
        try {
            try {
                clA = this.createGlobalClassLoader(JAR_A_1);
                this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
                clB = this.createGlobalClassLoader(JAR_B_1);
                Class<?> bFromA = clA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
                UclClassLoaderSanityTestCase.assertSame((Object)clB, (Object)bFromA.getClassLoader());
            }
            catch (Throwable throwable) {
                this.removeClassLoaderFromRepository(clB);
                throw throwable;
            }
            this.removeClassLoaderFromRepository(clB);
            this.assertCannotLoadClass(clA, "org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        }
        finally {
            this.removeClassLoaderFromRepository(clA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUclWithParentClassLoader() throws Exception {
        ClassLoader parent = this.createChildURLClassLoader(null, JAR_B_1);
        ClassLoader global = null;
        try {
            global = this.createGlobalClassLoaderWithParent(JAR_A_1, parent);
            Class<?> aFromGlobal = global.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertSame((Object)global, (Object)aFromGlobal.getClassLoader());
            Class<?> bFromGlobal = global.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclClassLoaderSanityTestCase.assertSame((Object)parent, (Object)bFromGlobal.getClassLoader());
            Class<?> bFromParent = parent.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclClassLoaderSanityTestCase.assertSame(bFromGlobal, bFromParent);
        }
        finally {
            this.removeClassLoaderFromRepository(global);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUclWithParentClassLoaderAndSameClassInDomain() throws Exception {
        ClassLoader parent = this.createChildURLClassLoader(null, JAR_B_1);
        ClassLoader globalA = null;
        ClassLoader globalB = null;
        try {
            globalA = this.createGlobalClassLoaderWithParent(JAR_A_1, parent);
            Class<?> aFromGlobal = globalA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertSame((Object)globalA, (Object)aFromGlobal.getClassLoader());
            globalB = this.createGlobalClassLoader(JAR_B_2);
            Class<?> bFromGlobalA = globalA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclClassLoaderSanityTestCase.assertSame((Object)globalB, (Object)bFromGlobalA.getClassLoader());
            Class<?> bFromParent = parent.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclClassLoaderSanityTestCase.assertSame((Object)parent, (Object)bFromParent.getClassLoader());
            UclClassLoaderSanityTestCase.assertNotSame(bFromGlobalA, bFromParent);
        }
        catch (Throwable throwable) {
            this.removeClassLoaderFromRepository(globalA);
            this.removeClassLoaderFromRepository(globalB);
            throw throwable;
        }
        this.removeClassLoaderFromRepository(globalA);
        this.removeClassLoaderFromRepository(globalB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUclLoaderOrdering() throws Exception {
        ClassLoader globalA = null;
        ClassLoader globalB = null;
        ClassLoader globalC = null;
        try {
            globalA = this.createGlobalClassLoader(JAR_A_1);
            globalB = this.createGlobalClassLoader(JAR_A_1);
            globalC = this.createGlobalClassLoader(JAR_A_1);
            Class<?> aFromA = globalA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            Class<?> aFromB = globalB.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            Class<?> aFromC = globalC.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclClassLoaderSanityTestCase.assertSame(aFromA, aFromB);
            UclClassLoaderSanityTestCase.assertSame(aFromA, aFromC);
            UclClassLoaderSanityTestCase.assertSame((Object)globalA, (Object)aFromA.getClassLoader());
        }
        catch (Throwable throwable) {
            this.removeClassLoaderFromRepository(globalA);
            this.removeClassLoaderFromRepository(globalB);
            this.removeClassLoaderFromRepository(globalC);
            throw throwable;
        }
        this.removeClassLoaderFromRepository(globalA);
        this.removeClassLoaderFromRepository(globalB);
        this.removeClassLoaderFromRepository(globalC);
    }
}

