/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.ucl.test;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.ucl.JBossUclDelegatingClassPoolFactory;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.aop.classpool.ucl.support.ParentLastURLClassLoader;
import org.jboss.test.aop.classpool.ucl.test.UclClassPoolTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UclClassPoolTest
extends AbstractTestCaseWithSetup {
    public static final URL JAR_A_1 = UclClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-jmx-test-classpool-a1.jar");
    public static final URL JAR_A_2 = UclClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-jmx-test-classpool-a2.jar");
    public static final URL JAR_B_1 = UclClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-jmx-test-classpool-b1.jar");
    public static final URL JAR_B_2 = UclClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-jmx-test-classpool-b2.jar");
    public static final URL JAR_C_1 = UclClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-jmx-test-classpool-c1.jar");
    public static final URL JAR_C_2 = UclClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-jmx-test-classpool-c2.jar");
    public static final String PACKAGE_A = "org.jboss.test.aop.classpool.ucl.support.excluded.a.";
    public static final String PACKAGE_B = "org.jboss.test.aop.classpool.ucl.support.excluded.b.";
    public static final String PACKAGE_C = "org.jboss.test.aop.classpool.ucl.support.excluded.c.";
    public static final String CLASS_A = "org.jboss.test.aop.classpool.ucl.support.excluded.a.A";
    public static final String CLASS_B = "org.jboss.test.aop.classpool.ucl.support.excluded.b.B";
    public static final String CLASS_C = "org.jboss.test.aop.classpool.ucl.support.excluded.c.C";
    private MBeanServer server;
    private LoaderRepository globalRepository;
    static final Set<ClassLoader> registeredClassLoaders = new HashSet<ClassLoader>();
    static final ObjectName MAIN_LOADER_REPOSITORY_OBJECT_NAME;

    public UclClassPoolTest(String name) {
        super(name);
        System.setProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
        this.server = MBeanServerFactory.createMBeanServer();
        MBeanServerLocator.setJBoss((MBeanServer)this.server);
        try {
            this.globalRepository = (LoaderRepository)this.server.invoke(MAIN_LOADER_REPOSITORY_OBJECT_NAME, "getInstance", new Object[0], new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        boolean enableSecurity;
        UclClassPoolTestDelegate delegate = new UclClassPoolTestDelegate(clazz);
        String property = System.getProperty("jboss.aop.secure", "true");
        delegate.enableSecurity = enableSecurity = Boolean.valueOf(property).booleanValue();
        return delegate;
    }

    protected static URL getURLRelativeToProjectRoot(String relativePath) {
        try {
            URL url = UclClassPoolTest.class.getProtectionDomain().getCodeSource().getLocation();
            String location = url.toString();
            int index = location.lastIndexOf("/asintegration-jmx/") + "/asintegration-jmx/".length();
            location = location.substring(0, index);
            location = location + relativePath;
            return new URL(location);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.enableTrace("org.jboss.aop.classpool");
        this.enableTrace("org.jboss.aop.classpool.ucl");
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public LoaderRepository getGlobalRepository() {
        return this.globalRepository;
    }

    protected ClassLoader createGlobalClassLoader(URL url) throws Exception {
        RepositoryClassLoader cl = this.globalRepository.newClassLoader(url, true);
        registeredClassLoaders.add((ClassLoader)cl);
        return cl;
    }

    protected ClassPool createGlobalClassPool(URL url) throws Exception {
        ClassLoader loader = this.createGlobalClassLoader(url);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassLoader createGlobalClassLoaderWithParent(URL url, ClassLoader parent) throws Exception {
        UnifiedClassLoader3 cl = new UnifiedClassLoader3(url, null, parent, this.globalRepository);
        this.globalRepository.addClassLoader((ClassLoader)cl);
        registeredClassLoaders.add((ClassLoader)cl);
        return cl;
    }

    protected ClassPool createGlobalClassPoolWithParent(URL url, ClassPool parent) throws Exception {
        ClassLoader parentLoader = parent != null ? parent.getClassLoader() : null;
        ClassLoader loader = this.createGlobalClassLoaderWithParent(url, parentLoader);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected void removeClassLoaderFromRepository(ClassLoader cl) {
        if (cl != null && cl instanceof RepositoryClassLoader) {
            LoaderRepository repository = ((RepositoryClassLoader)cl).getLoaderRepository();
            repository.removeClassLoader(cl);
        }
    }

    protected void removeClassPool(ClassPool pool) {
        ClassLoader cl;
        if (pool != null && (cl = pool.getClassLoader()) != null) {
            this.removeClassLoaderFromRepository(cl);
            AspectManager.instance().unregisterClassLoader(cl);
            registeredClassLoaders.remove(cl);
            this.deleteTempDir();
        }
    }

    private void deleteTempDir() {
        String[] uclFiles;
        File dir = new File(".");
        for (String uclFile : uclFiles = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("ucl");
            }
        })) {
            this.deleteRecursively(dir, uclFile);
        }
    }

    private void deleteRecursively(File dir, String name) {
        File file = new File(dir, name);
        if (file.isDirectory()) {
            String[] fileNames;
            for (String fileName : fileNames = file.list()) {
                this.deleteRecursively(file, fileName);
            }
        }
        file.delete();
    }

    protected void assertCannotLoadClass(ClassLoader cl, String className) {
        try {
            cl.loadClass(className);
            UclClassPoolTest.fail((String)("Should not have been able to load " + className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void assertCannotLoadCtClass(ClassPool pool, String className) {
        try {
            pool.get(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void assertCannotLoadClass(LoaderRepository repository, String className) {
        try {
            repository.loadClass(className);
            UclClassPoolTest.fail((String)("Should not have been able to load " + className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ClassLoader createChildClassLoader(URL url, boolean parentFirst) throws Exception {
        HeirarchicalLoaderRepository3 repository = new HeirarchicalLoaderRepository3(this.getServer(), MAIN_LOADER_REPOSITORY_OBJECT_NAME);
        repository.setUseParentFirst(parentFirst);
        RepositoryClassLoader cl = repository.newClassLoader(url, true);
        registeredClassLoaders.add((ClassLoader)cl);
        return cl;
    }

    protected ClassPool createChildClassPool(URL url, boolean parentFirst) throws Exception {
        ClassLoader loader = this.createChildClassLoader(url, parentFirst);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassLoader createChildURLClassLoader(ClassLoader parent, URL url) {
        URLClassLoader cl = new URLClassLoader(new URL[]{url}, parent);
        registeredClassLoaders.add(cl);
        return cl;
    }

    protected ClassLoader createChildURLClassLoaderParentLast(ClassLoader parent, URL url) {
        ParentLastURLClassLoader cl = new ParentLastURLClassLoader(new URL[]{url}, parent);
        registeredClassLoaders.add(cl);
        return cl;
    }

    protected ClassPool createChildURLClassPool(ClassPool parent, URL url) {
        ClassLoader parentLoader = parent != null ? parent.getClassLoader() : null;
        ClassLoader cl = this.createChildURLClassLoader(parentLoader, url);
        registeredClassLoaders.add(cl);
        return AspectManager.instance().registerClassLoader(cl);
    }

    protected ClassPool createChildURLClassPoolParentLast(ClassPool parent, URL url) {
        ClassLoader parentLoader = parent != null ? parent.getClassLoader() : null;
        ClassLoader cl = this.createChildURLClassLoaderParentLast(parentLoader, url);
        registeredClassLoaders.add(cl);
        ClassPool pool = AspectManager.instance().registerClassLoader(cl);
        pool.childFirstLookup = true;
        return pool;
    }

    public void testClassesNotOnClasspath() {
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), CLASS_A);
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), CLASS_B);
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), CLASS_C);
    }

    static {
        try {
            MAIN_LOADER_REPOSITORY_OBJECT_NAME = new ObjectName("JMImplementation:name=Default,service=LoaderRepository");
            AspectManager.setClassPoolFactory((ScopedClassPoolFactory)new JBossUclDelegatingClassPoolFactory(new File(".")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

